/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale;

import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.locale.ILabelFetcher;
import com.arcway.lib.java.maps.HashMap_;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class LocaleHelper {
    public static final int MIN_DISTANCE = 0;
    public static final int MAX_DISTANCE = 3;
    public static final Locale FALLBACK = Locale.ENGLISH;
    public static final String SAARL\u00c4NNISCH = "s\u00e4";

    public static Locale[] getAvailableLocales() {
        ArrayList<Locale> myLocales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        myLocales.add(new Locale(SAARL\u00c4NNISCH));
        return myLocales.toArray(new Locale[0]);
    }

    public static String getDisplayLanguage(Locale locale) {
        return LocaleHelper.getDisplayLanguage(locale, Locale.getDefault());
    }

    public static String getDisplayLanguage(Locale locale, Locale inLocale) {
        String displayName = locale.getLanguage().equals(SAARL\u00c4NNISCH) ? "Saarl\u00e4nnisch" : locale.getDisplayLanguage(inLocale);
        return displayName;
    }

    public static Locale findNearestLocale(ICollection_<Locale> givenLocales, Locale wishedLocale) {
        Locale foundLocale = LocaleHelper.findNearerLocale(givenLocales, FALLBACK, null, Integer.MAX_VALUE);
        foundLocale = LocaleHelper.findNearerLocale(givenLocales, wishedLocale, foundLocale, 3);
        return foundLocale;
    }

    private static Locale findNearerLocale(ICollection_<Locale> givenLocales, Locale wishedLocale, Locale alreadyFoundLocale, int alreadyFoundDistance) {
        Locale foundLocale = alreadyFoundLocale;
        int foundDistance = alreadyFoundDistance;
        for (Locale currentLocale : givenLocales) {
            int currentDistance = LocaleHelper.getDistance(wishedLocale, currentLocale);
            if (currentDistance >= foundDistance) continue;
            foundLocale = currentLocale;
            foundDistance = currentDistance;
        }
        return foundLocale;
    }

    public static int getDistance(Locale locale1, Locale locale2) {
        String variant2;
        String variant1;
        String country2;
        String country1;
        String language2;
        String language1 = locale1.getLanguage();
        int distance = language1.equals(language2 = locale2.getLanguage()) && !language1.equals("") ? ((country1 = locale1.getCountry()).equals(country2 = locale2.getCountry()) && !country1.equals("") ? ((variant1 = locale1.getVariant()).equals(variant2 = locale1.getVariant()) && !variant1.equals("") ? 0 : 1) : 2) : 3;
        return distance;
    }

    public static <LP, L> L getNearestLabel(Locale wishedLocale, ICollection_<LP> labelProviders, ILabelFetcher<LP, L> labelFetcher) {
        HashMap_<Object, L> valuableLabels = new HashMap_<Object, L>(labelProviders.size(), IHasher_.EQUALS_HASHER);
        for (Object labelProvider : labelProviders) {
            L label = labelFetcher.getLabel(labelProvider);
            if (label == null) continue;
            Locale locale = labelFetcher.getLocale(labelProvider);
            valuableLabels.put(locale, label);
        }
        Locale nearestLocale = LocaleHelper.findNearestLocale(valuableLabels.keySet(), wishedLocale);
        L bestLabel = nearestLocale != null ? (L)valuableLabels.getByKey(nearestLocale) : null;
        return bestLabel;
    }
}

