/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.io;

import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.JvmExternalResourceInteractionExceptionFactory;
import com.arcway.lib.operating.SafeRunner;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;

public class TextFileHelper {
    public static String getFileContentAsString(File f, String encoding) throws JvmExternalResourceInteractionException, UnsupportedEncodingException {
        String resultString = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream((int)f.length());
        DataCopyHelper.copyFile(f, byteArrayOutputStream, true);
        resultString = byteArrayOutputStream.toString(encoding);
        return resultString;
    }

    public static String getStreamContentAsString(InputStream is, String encoding) throws JvmExternalResourceInteractionException, UnsupportedEncodingException {
        String resultString = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataCopyHelper.copyFile(is, byteArrayOutputStream);
        resultString = byteArrayOutputStream.toString(encoding);
        return resultString;
    }

    public static void saveStringAsFile(final String filecontent, final File targetFile, final String encoding) throws JvmExternalResourceInteractionException {
        String defaultmessage = MessageFormat.format("Error while writing String into file {0}.", targetFile.getPath());
        JvmExternalResourceInteractionExceptionFactory exceptionFactory = new JvmExternalResourceInteractionExceptionFactory(defaultmessage);
        SafeRunner.VoidRunnable runnable = new SafeRunner.VoidRunnable(){

            @Override
            public void run() throws Throwable {
                Throwable destinationCloseEx;
                Throwable primaryEx;
                block13: {
                    primaryEx = null;
                    destinationCloseEx = null;
                    PrintWriter printWriter = new PrintWriter(targetFile, encoding);
                    try {
                        try {
                            printWriter.write(filecontent);
                            printWriter.flush();
                        }
                        catch (Throwable th) {
                            primaryEx = th;
                            try {
                                printWriter.close();
                            }
                            catch (Throwable th2) {
                                destinationCloseEx = th2;
                            }
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            printWriter.close();
                        }
                        catch (Throwable th) {
                            destinationCloseEx = th;
                        }
                        throw throwable;
                    }
                    try {
                        printWriter.close();
                    }
                    catch (Throwable th) {
                        destinationCloseEx = th;
                    }
                }
                if (primaryEx != null) {
                    throw primaryEx;
                }
                if (destinationCloseEx != null) {
                    throw destinationCloseEx;
                }
            }
        };
        SafeRunner.safeVoidExecute(runnable, exceptionFactory);
    }
}

