/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.stringtools.StringCanonicalizer;

public class XMLElementName {
    private final String nameSpace;
    private final String elementName;

    public XMLElementName(String nameSpace, String elementName) {
        Assert.checkArgumentBeeingNotNull(elementName);
        Assert.checkStringToBeNotEmpty(elementName);
        this.nameSpace = nameSpace != null ? StringCanonicalizer.getSystemWideCanonicalString(nameSpace) : null;
        this.elementName = StringCanonicalizer.getSystemWideCanonicalString(elementName);
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String toString() {
        return String.valueOf(To.string(this)) + " (\"" + this.getElementName() + "\")";
    }
}

