/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.commandline.dumptool;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.util.PasswordEncoder2;
import de.plans.lib.util.StacktraceConverter;
import de.plans.lib.xml.encoding.EOList;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.ServerOperationsPermissionChecker;
import de.plans.psc.client.communication.EXNotLoggedInOrConnectionBroken;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.transmissionprocessor.RequestTransmissionAndUpdateEnquiryProcessor;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOLoginResponse;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.EOUserAndGroupAndPermissions;
import de.plans.psc.shared.message.PSCPlainMessageDataFactory;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Dumpcommand {
    private static final ILogger logger = Logger.getLogger(Dumpcommand.class);
    private static final String LineSep = StacktraceConverter.LineSep;
    public static final String URL_PATH_SEPARATOR = "/";
    public static final String DOT_ZIP = ".zip";
    private static final int NOTIFICATION_ENQUIRY_INTERVAL = 10000;
    private static final PSCApplicationIdentifier APPLICATION_IDENTIFIER = new PSCApplicationIdentifier("COCKPIT", "ARCWAY Cockpit", "3.8.0", "13", "3.6.0");
    private static final PSCClientLicenseInfo LICENSE_INFO = new PSCClientLicenseInfo(true, "COCKPIT-3.6");
    private EOUserAndGroupAndPermissions userData;
    private RequestTransmissionAndUpdateEnquiryProcessor transmissionProcessor;
    private static final String MSG_GROUP_EXPORT = "frame.Export";
    private static final String MSG_SUBID_DUMP_PROJECTS = "frame.DumpProjects";

    public static void main(String[] args) {
        Dumpcommand.System_out_print("ARCWAY Cockpit " + APPLICATION_IDENTIFIER.getClientVersion() + " Server Dump Tool ($Revision: 1.182 $) \n");
        URL serverURL = null;
        String username = null;
        String password = null;
        File dumpfile = null;
        Boolean overwriteExistingDumpfile = null;
        boolean parametersValid = true;
        String optionalProjectUID = null;
        HashSet<String> projectUIDBlackList = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        int argn = 0;
        while (argn < args.length && parametersValid) {
            String arg = args[argn];
            if ("-u".equals(arg)) {
                if (username != null) {
                    sb.append("-u option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-u option specified but no username\n");
                    parametersValid = false;
                    continue;
                }
                username = args[argn + 1];
                argn += 2;
                continue;
            }
            if ("-p".equals(arg)) {
                if (password != null) {
                    sb.append("-p option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-p option specified but no password\n");
                    parametersValid = false;
                    continue;
                }
                password = args[argn + 1];
                argn += 2;
                continue;
            }
            if ("-s".equals(arg)) {
                if (serverURL != null) {
                    sb.append("-s option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-s option specified but no URL\n");
                    parametersValid = false;
                    continue;
                }
                try {
                    serverURL = new URL(args[argn + 1]);
                    if (!args[argn + 1].endsWith(URL_PATH_SEPARATOR)) {
                        sb.append("Warning: The specified server URL does not end with a '/' character. Please try to append a '/' character if you experience connection failures.\n");
                    }
                }
                catch (MalformedURLException e) {
                    sb.append("The specified server URL is invalid: " + e.getLocalizedMessage() + "\n");
                    parametersValid = false;
                }
                argn += 2;
                continue;
            }
            if ("-x".equals(arg)) {
                if (optionalProjectUID != null) {
                    sb.append("-x option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-x option specified but no projectUID\n");
                    parametersValid = false;
                    continue;
                }
                optionalProjectUID = args[argn + 1];
                argn += 2;
                continue;
            }
            if ("-e".equals(arg)) {
                if (argn + 1 >= args.length) {
                    sb.append("-e option specified but no projectUID\n");
                    parametersValid = false;
                    continue;
                }
                String projectUIDToExclude = args[argn + 1];
                projectUIDBlackList.add(projectUIDToExclude);
                argn += 2;
                continue;
            }
            if ("-f".equals(arg)) {
                if (dumpfile != null) {
                    sb.append("-f option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-f option specified but no dumpfile \n");
                    parametersValid = false;
                    continue;
                }
                if (!args[argn + 1].endsWith(DOT_ZIP)) {
                    sb.append("Warning: A cockpit server dump file actually is a zip archive and should be stored in a File with .zip extension.\n");
                }
                dumpfile = new File(args[argn + 1]);
                argn += 2;
                continue;
            }
            if ("-o".equals(arg)) {
                if (overwriteExistingDumpfile != null) {
                    sb.append("-o option must not be specified more than once \n");
                    parametersValid = false;
                    continue;
                }
                if (argn + 1 >= args.length) {
                    sb.append("-o option specified but no y/n \n");
                    parametersValid = false;
                    continue;
                }
                String overwite = args[argn + 1];
                if ("y".equalsIgnoreCase(overwite)) {
                    overwriteExistingDumpfile = Boolean.TRUE;
                } else if ("n".equalsIgnoreCase(overwite)) {
                    overwriteExistingDumpfile = Boolean.FALSE;
                } else {
                    sb.append("\"" + overwite + "\" is not a valid parameter for the -o option. Valid values are: y and n \n");
                    parametersValid = false;
                }
                argn += 2;
                continue;
            }
            sb.append("\"" + arg + "\" is not a valid parameter.");
            parametersValid = false;
        }
        if (parametersValid) {
            if (serverURL == null) {
                sb.append("Mandatory parameter serverurl is missing. \n");
                parametersValid = false;
            }
            if (dumpfile == null) {
                sb.append("Mandatory parameter dumpfile is missing. \n");
                parametersValid = false;
            }
        }
        if (parametersValid && (username == null && password != null || username != null && password == null)) {
            sb.append("Either specify username and password or none of them. \n");
            parametersValid = false;
        }
        if (!parametersValid) {
            StringBuilder mb = new StringBuilder();
            mb.append(sb);
            mb.append(LineSep);
            mb.append(LineSep);
            mb.append(Dumpcommand.getUsageInformation());
            Dumpcommand.System_out_print(mb.toString());
            System.exit(-1);
        } else if (sb.length() > 0) {
            StringBuilder mb = new StringBuilder();
            mb.append(sb);
            mb.append(LineSep);
            Dumpcommand.System_out_print(mb.toString());
        }
        if (overwriteExistingDumpfile == null) {
            overwriteExistingDumpfile = Boolean.FALSE;
        }
        if (dumpfile != null && dumpfile.exists() && !overwriteExistingDumpfile.booleanValue()) {
            Dumpcommand.System_out_print("Will not overwrite exiting dumpfile. - Aborting." + LineSep);
            System.exit(-2);
        }
        try {
            Dumpcommand.System_out_print("Starting Dump Command at: " + new Date(System.currentTimeMillis()) + LineSep);
            Dumpcommand dumpcommand = new Dumpcommand();
            dumpcommand.createDump(serverURL, username, password, optionalProjectUID, projectUIDBlackList, dumpfile);
            Dumpcommand.System_out_print("Execution of Dump Command completed at: " + new Date(System.currentTimeMillis()));
        }
        catch (ServerDumpAbortedException e) {
            Dumpcommand.System_out_printThrowable(e);
            System.exit(-3);
        }
        catch (Throwable e) {
            Dumpcommand.System_out_printThrowable(e);
            System.exit(-4);
        }
    }

    private static String getUsageInformation() {
        StringBuffer usage = new StringBuffer();
        String executableCommand = "java -jar cockpit-dump.jar";
        usage.append("Usage: " + executableCommand + " -s serverurl -f dumpfile [-o y|n] [-u username -p password] \n");
        usage.append("\n");
        usage.append("    -s serverurl \n");
        usage.append("       The url of the ARCWAY Cockpit Server to be dumped  \n");
        usage.append("       e.g.: http://localhost:8080/CockpitServer/ \n");
        usage.append("\n");
        usage.append("    -f dumpfile \n");
        usage.append("       The name of the file that shall be used to store the serverdump \n");
        usage.append("       e.g.: CockpitServerDump-20080509.zip \n");
        usage.append("\n");
        usage.append("    -o y|n \n");
        usage.append("       overwrite the dumpfile if it already exists \n");
        usage.append("       y: overwrite\n");
        usage.append("       n: do not overwrite, but abort\n");
        usage.append("       defaults to n\n");
        usage.append("\n");
        usage.append("    -u username \n");
        usage.append("       The name of the ARCWAY Cockpit Server User that will be used to log in to\n");
        usage.append("       the ARCWAY Cockpit Server. This User must have sufficient privileges to\n");
        usage.append("       create a server dump, i.e. the User must be the user 'Administrator', a\n");
        usage.append("       member of the group 'Administrators' or 'Administrate System' Permission.\n");
        usage.append("       This parameter must be omitted if the ARCWAY Cockpit Server is configured\n");
        usage.append("       for Single Sign-On.\n");
        usage.append("\n");
        usage.append("    -p password \n");
        usage.append("       The password of the ARCWAY Cockpit Server specified by -u\n");
        usage.append("       This parameter must be omitted if the ARCWAY Cockpit Server is configured\n");
        usage.append("       for Single Sign-On.\n");
        usage.append("\n");
        usage.append("    -x projectUID \n");
        usage.append("       Optional parameter with a projectUID from an ARCWAY Cockpit project.\n");
        usage.append("       if present, a project dump of the project with the specified UID is requested.\n");
        usage.append("       If this parameter is not present, a serverdump is requested (default case).\n");
        usage.append("\n");
        usage.append("    -e projectUID \n");
        usage.append("       Optional parameter with a projectUID from an ARCWAY Cockpit project.\n");
        usage.append("       This parameter can only be used for server dumps (i.e. parameter -x not set).\n");
        usage.append("       The project with the specified UID will be excluded from the server dump.\n");
        usage.append("       The parameter can be used multiple times.\n");
        usage.append("\n");
        return usage.toString();
    }

    private void createDump(URL serverURL, String username, String password, String optionalProjectUID, Set<? extends String> projectUIDBlackList, File dumpfile) throws EXNotLoggedInOrConnectionBroken, IOException, EXDecoderException, ServerDumpAbortedException {
        Authenticator.setDefault(PSCAuthenticator.getInstance());
        PSCPlainMessageDataFactory messageDataFactory = PSCPlainMessageDataFactory.getDefault();
        this.transmissionProcessor = new RequestTransmissionAndUpdateEnquiryProcessor("", serverURL, 10000, messageDataFactory, new RequestTransmissionAndUpdateEnquiryProcessor.INotificationEnquiryResponseConsumer(){

            @Override
            public void processNotificationEnquiryResponse(IRequestJob job) {
                try {
                    job.getServerResponse();
                    Dumpcommand.System_out_print(" *");
                }
                catch (Throwable th) {
                    Dumpcommand.System_out_printThrowable(th);
                }
            }
        });
        Dumpcommand.System_out_print("   " + Dumpcommand.current_hh_mm_ss() + " - Trying to log in to server \"" + serverURL + "\":");
        String authenticatedUsername = this.login(username, password);
        Dumpcommand.System_out_print(" Login succeeded as user >" + authenticatedUsername + "<." + LineSep);
        this.dumpServerOrProject(optionalProjectUID, dumpfile, projectUIDBlackList);
        IRequestJob disconnectRequestJob = this.transmissionProcessor.chargeDisconnectRequest();
        disconnectRequestJob.waitUntilRequestIsProcessed(500L);
    }

    private String login(String username, String password) throws EXNotLoggedInOrConnectionBroken, IOException, EXDecoderException, ServerDumpAbortedException {
        PSCAuthenticator.RequestorInfo requestorInfo;
        PasswordAuthentication passwordAuthentication;
        String typedUsername;
        String pscPassword2 = null;
        ISnoopRequestJob snoopJob = this.transmissionProcessor.chargeSnoopRequest();
        snoopJob.waitUntilRequestIsProcessed(0L);
        IOException ioException = null;
        try {
            snoopJob.throwTransmissionExceptions();
        }
        catch (IOException e) {
            ioException = e;
        }
        if (snoopJob.getAuthenticatedUsersName() != null) {
            typedUsername = snoopJob.getAuthenticatedUsersName();
            pscPassword2 = "<dummy>";
            passwordAuthentication = null;
            requestorInfo = null;
        } else if (snoopJob.getAuthenticationRequestor() != null) {
            if (username == null || password == null) {
                throw new ServerDumpAbortedException("Application Server requested Username/Password authentication but no Username/Password was specified.");
            }
            PSCAuthenticator.RequestorInfo requestor = snoopJob.getAuthenticationRequestor();
            logger.debug("The following system asked for authentication: " + requestor.toString());
            typedUsername = username;
            pscPassword2 = "<dummy>";
            passwordAuthentication = new PasswordAuthentication(username, password.toCharArray());
            requestorInfo = requestor;
        } else if (ioException == null) {
            if (username == null || password == null) {
                throw new ServerDumpAbortedException("Cockpit Server requested Username/Password authentication but no Username/Password was specified.");
            }
            String encodedPassword2 = "";
            if (ServerConnection.transmitPasswordsAsCleartext() || PasswordEncoder2.isEncoded(password)) {
                encodedPassword2 = password;
            } else if (!password.equals("")) {
                encodedPassword2 = PasswordEncoder2.encodePassword(password);
            }
            typedUsername = username;
            pscPassword2 = encodedPassword2;
            passwordAuthentication = null;
            requestorInfo = null;
        } else {
            throw new ServerDumpAbortedException("Problem while connecting to server.", ioException);
        }
        IRequestJob loginRequestJob = this.transmissionProcessor.chargeLoginRequest(APPLICATION_IDENTIFIER, LICENSE_INFO, passwordAuthentication, requestorInfo, typedUsername, pscPassword2);
        loginRequestJob.waitUntilRequestIsProcessed(0L);
        EOServerResponse res = loginRequestJob.getServerResponse();
        if (res == null) {
            throw new ServerDumpAbortedException("Server Login failed! Reason: Server did not return a response on the login request.");
        }
        EOLoginResponse loginRes = (EOLoginResponse)res.getResponseData();
        String loginStatus = loginRes.getLoginStatus();
        if (!loginStatus.equals("loginOk")) {
            if (loginStatus.equals("invalidUserNameOrPassword")) {
                throw new ServerDumpAbortedException("Server Login failed! Reason: Invalid username/password combination.");
            }
            if (loginStatus.equals("noLicenseAvailable")) {
                throw new ServerDumpAbortedException("Server Login failed! Reason: No License available. ");
            }
            if (loginStatus.equals("incompatibleClient")) {
                throw new ServerDumpAbortedException("Server Login failed! Reason: Client version not compatible with server. ");
            }
            throw new ServerDumpAbortedException("Server Login failed! (cause:" + loginStatus + ")");
        }
        this.userData = loginRes.getUser();
        this.transmissionProcessor.setNotificationEnquiryInterval(10000L);
        this.transmissionProcessor.startNotificationEnquiry();
        return typedUsername;
    }

    private void dumpServerOrProject(String optionalProjectUID, File dumpFile, Set<? extends String> projectUIDBlackList) throws EXNotLoggedInOrConnectionBroken, IOException, EXDecoderException, ServerDumpAbortedException {
        EOClientRequest req;
        boolean userHasPermissions;
        Collection<EOPermission> permissionsOfCurrentUser = this.userData.getAllPermissions();
        boolean bl = userHasPermissions = ServerOperationsPermissionChecker.isAdminUser(permissionsOfCurrentUser) || ServerOperationsPermissionChecker.isOperator(permissionsOfCurrentUser);
        if (!userHasPermissions) {
            throw new ServerDumpAbortedException("User has no permission to dump this server");
        }
        Dumpcommand.System_out_print("   " + Dumpcommand.current_hh_mm_ss() + " - Requesting Dump:");
        if (optionalProjectUID != null) {
            EOList<EOValue> projects = new EOList<EOValue>();
            projects.add(new EOValue(optionalProjectUID));
            req = new EOClientRequest(MSG_GROUP_EXPORT, MSG_SUBID_DUMP_PROJECTS, projects);
        } else {
            EOList<EOValue> blacklist;
            if (projectUIDBlackList.isEmpty()) {
                blacklist = null;
            } else {
                blacklist = new EOList<EOValue>();
                for (String string : projectUIDBlackList) {
                    blacklist.add(new EOValue(string));
                }
            }
            req = new EOClientRequest("Dump", "DumpServer", blacklist);
        }
        IRequestJob dumpServerRequestJob = this.transmissionProcessor.chargeRequest(req);
        EOServerResponse eOServerResponse = dumpServerRequestJob.getServerResponse();
        Dumpcommand.System_out_print(" Dump now available for Download." + LineSep);
        String transferID = ((EOValue)eOServerResponse.getResponseData()).getValue();
        Dumpcommand.System_out_print("   " + Dumpcommand.current_hh_mm_ss() + " - Downloading dump to file \"" + dumpFile.getAbsolutePath() + "\":");
        IDataTransferRequestJob fileDownloadRequestJob = this.transmissionProcessor.chargeFileDownloadRequest(Collections.singletonList(transferID), Collections.singletonList(dumpFile));
        fileDownloadRequestJob.waitUntilRequestIsProcessed(0L);
        if (fileDownloadRequestJob.getTransferResult() != IDataTransferRequestJob.TransferState.TRANSFER_COMPLETED_SUCCESSFULLY) {
            throw new ServerDumpAbortedException("Problem while downloading Dump File. (Transfer State: " + fileDownloadRequestJob.getTransferResult() + ")", fileDownloadRequestJob.getErrorCause());
        }
        Dumpcommand.System_out_print(" Completely transferred Dump" + LineSep);
    }

    private static String current_hh_mm_ss() {
        String dateString = new Date(System.currentTimeMillis()).toString();
        try {
            return dateString.substring(dateString.indexOf(58) - 2, dateString.lastIndexOf(58) + 3);
        }
        catch (Throwable th) {
            return dateString;
        }
    }

    private static void System_out_printThrowable(Throwable th) {
        StringBuilder sb = new StringBuilder();
        sb.append(LineSep);
        sb.append(Dumpcommand.current_hh_mm_ss());
        sb.append(" ");
        sb.append(StacktraceConverter.stacktraceToString(th));
        sb.append(LineSep);
        Dumpcommand.System_out_print(sb.toString());
    }

    private static synchronized void System_out_print(String msg) {
        System.out.print(msg);
        System.out.flush();
    }

    private static class ServerDumpAbortedException
    extends Exception {
        public ServerDumpAbortedException(String message, Throwable cause) {
            super(message, cause);
        }

        public ServerDumpAbortedException(String message) {
            super(message);
        }
    }
}

