/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.ClosedDirectoryStreamException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SecureDirectoryStream;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.UnixChannelFactory;
import sun.nio.fs.UnixConstants;
import sun.nio.fs.UnixDirectoryStream;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileModeAttribute;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.nio.fs.Util;

class UnixSecureDirectoryStream
implements SecureDirectoryStream<Path> {
    private final UnixDirectoryStream ds;
    private final int dfd;

    UnixSecureDirectoryStream(UnixPath unixPath, long l, int n, DirectoryStream.Filter<? super Path> filter) {
        this.ds = new UnixDirectoryStream(unixPath, l, filter);
        this.dfd = n;
    }

    @Override
    public void close() throws IOException {
        this.ds.writeLock().lock();
        try {
            if (this.ds.closeImpl()) {
                UnixNativeDispatcher.close(this.dfd);
            }
        }
        finally {
            this.ds.writeLock().unlock();
        }
    }

    @Override
    public Iterator<Path> iterator() {
        return this.ds.iterator(this);
    }

    private UnixPath getName(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SecureDirectoryStream<Path> newDirectoryStream(Path path, LinkOption ... linkOptionArray) throws IOException {
        UnixPath unixPath = this.getName(path);
        UnixPath unixPath2 = this.ds.directory().resolve(unixPath);
        boolean bl = Util.followLinks(linkOptionArray);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            unixPath2.checkRead();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            int n = -1;
            int n2 = -1;
            long l = 0L;
            try {
                int n3 = UnixConstants.O_RDONLY;
                if (!bl) {
                    n3 |= UnixConstants.O_NOFOLLOW;
                }
                n = UnixNativeDispatcher.openat(this.dfd, unixPath.asByteArray(), n3, 0);
                n2 = UnixNativeDispatcher.dup(n);
                l = UnixNativeDispatcher.fdopendir(n);
            }
            catch (UnixException unixException) {
                if (n != -1) {
                    UnixNativeDispatcher.close(n);
                }
                if (n2 != -1) {
                    UnixNativeDispatcher.close(n2);
                }
                if (unixException.errno() == UnixConstants.ENOTDIR) {
                    throw new NotDirectoryException(unixPath.toString());
                }
                unixException.rethrowAsIOException(unixPath);
            }
            UnixSecureDirectoryStream unixSecureDirectoryStream = new UnixSecureDirectoryStream(unixPath2, l, n2, null);
            return unixSecureDirectoryStream;
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> set, FileAttribute<?> ... fileAttributeArray) throws IOException {
        UnixPath unixPath = this.getName(path);
        int n = UnixFileModeAttribute.toUnixMode(UnixFileModeAttribute.ALL_READWRITE, fileAttributeArray);
        String string = this.ds.directory().resolve(unixPath).getPathForPermissionCheck();
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            try {
                FileChannel fileChannel = UnixChannelFactory.newFileChannel(this.dfd, unixPath, string, set, n);
                return fileChannel;
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(unixPath);
                SeekableByteChannel seekableByteChannel = null;
                this.ds.readLock().unlock();
                return seekableByteChannel;
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void implDelete(Path path, boolean bl, int n) throws IOException {
        UnixPath unixPath = this.getName(path);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.ds.directory().resolve(unixPath).checkDelete();
        }
        this.ds.readLock().lock();
        try {
            if (!this.ds.isOpen()) {
                throw new ClosedDirectoryStreamException();
            }
            if (!bl) {
                UnixFileAttributes unixFileAttributes = null;
                try {
                    unixFileAttributes = UnixFileAttributes.get(this.dfd, unixPath, false);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(unixPath);
                }
                n = unixFileAttributes.isDirectory() ? UnixConstants.AT_REMOVEDIR : 0;
            }
            try {
                UnixNativeDispatcher.unlinkat(this.dfd, unixPath.asByteArray(), n);
            }
            catch (UnixException unixException) {
                if ((n & UnixConstants.AT_REMOVEDIR) != 0 && (unixException.errno() == UnixConstants.EEXIST || unixException.errno() == UnixConstants.ENOTEMPTY)) {
                    throw new DirectoryNotEmptyException(null);
                }
                unixException.rethrowAsIOException(unixPath);
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    @Override
    public void deleteFile(Path path) throws IOException {
        this.implDelete(path, true, 0);
    }

    @Override
    public void deleteDirectory(Path path) throws IOException {
        this.implDelete(path, true, UnixConstants.AT_REMOVEDIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Path path, SecureDirectoryStream<Path> secureDirectoryStream, Path path2) throws IOException {
        UnixPath unixPath = this.getName(path);
        UnixPath unixPath2 = this.getName(path2);
        if (secureDirectoryStream == null) {
            throw new NullPointerException();
        }
        if (!(secureDirectoryStream instanceof UnixSecureDirectoryStream)) {
            throw new ProviderMismatchException();
        }
        UnixSecureDirectoryStream unixSecureDirectoryStream = (UnixSecureDirectoryStream)secureDirectoryStream;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            this.ds.directory().resolve(unixPath).checkWrite();
            unixSecureDirectoryStream.ds.directory().resolve(unixPath2).checkWrite();
        }
        this.ds.readLock().lock();
        try {
            unixSecureDirectoryStream.ds.readLock().lock();
            try {
                if (!this.ds.isOpen() || !unixSecureDirectoryStream.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixNativeDispatcher.renameat(this.dfd, unixPath.asByteArray(), unixSecureDirectoryStream.dfd, unixPath2.asByteArray());
                }
                catch (UnixException unixException) {
                    if (unixException.errno() == UnixConstants.EXDEV) {
                        throw new AtomicMoveNotSupportedException(unixPath.toString(), unixPath2.toString(), unixException.errorString());
                    }
                    unixException.rethrowAsIOException(unixPath, unixPath2);
                }
            }
            finally {
                unixSecureDirectoryStream.ds.readLock().unlock();
            }
        }
        finally {
            this.ds.readLock().unlock();
        }
    }

    private <V extends FileAttributeView> V getFileAttributeViewImpl(UnixPath unixPath, Class<V> clazz, boolean bl) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        Class<V> clazz2 = clazz;
        if (clazz2 == BasicFileAttributeView.class) {
            return (V)new BasicFileAttributeViewImpl(unixPath, bl);
        }
        if (clazz2 == PosixFileAttributeView.class || clazz2 == FileOwnerAttributeView.class) {
            return (V)new PosixFileAttributeViewImpl(unixPath, bl);
        }
        return (V)((FileAttributeView)null);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Class<V> clazz) {
        return this.getFileAttributeViewImpl(null, clazz, false);
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> clazz, LinkOption ... linkOptionArray) {
        UnixPath unixPath = this.getName(path);
        boolean bl = Util.followLinks(linkOptionArray);
        return this.getFileAttributeViewImpl(unixPath, clazz, bl);
    }

    private class PosixFileAttributeViewImpl
    extends BasicFileAttributeViewImpl
    implements PosixFileAttributeView {
        PosixFileAttributeViewImpl(UnixPath unixPath, boolean bl) {
            super(unixPath, bl);
        }

        private void checkWriteAndUserAccess() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                ((BasicFileAttributeViewImpl)this).checkWriteAccess();
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
        }

        @Override
        public String name() {
            return "posix";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public PosixFileAttributes readAttributes() throws IOException {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (this.file == null) {
                    UnixSecureDirectoryStream.this.ds.directory().checkRead();
                } else {
                    UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                }
                securityManager.checkPermission(new RuntimePermission("accessUserInformation"));
            }
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                try {
                    UnixFileAttributes unixFileAttributes;
                    UnixFileAttributes unixFileAttributes2 = unixFileAttributes = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    return unixFileAttributes2;
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                    PosixFileAttributes posixFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return posixFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPermissions(Set<PosixFilePermission> set) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchmod(n, UnixFileModeAttribute.toUnixMode(set));
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && n >= 0) {
                        UnixNativeDispatcher.close(n);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setOwners(int n, int n2) throws IOException {
            this.checkWriteAndUserAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n3 = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    UnixNativeDispatcher.fchown(n3, n, n2);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                }
                finally {
                    if (this.file != null && n3 >= 0) {
                        UnixNativeDispatcher.close(n3);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        @Override
        public UserPrincipal getOwner() throws IOException {
            return this.readAttributes().owner();
        }

        @Override
        public void setOwner(UserPrincipal userPrincipal) throws IOException {
            if (!(userPrincipal instanceof UnixUserPrincipals.User)) {
                throw new ProviderMismatchException();
            }
            if (userPrincipal instanceof UnixUserPrincipals.Group) {
                throw new IOException("'owner' parameter can't be a group");
            }
            int n = ((UnixUserPrincipals.User)userPrincipal).uid();
            this.setOwners(n, -1);
        }

        @Override
        public void setGroup(GroupPrincipal groupPrincipal) throws IOException {
            if (!(groupPrincipal instanceof UnixUserPrincipals.Group)) {
                throw new ProviderMismatchException();
            }
            int n = ((UnixUserPrincipals.Group)groupPrincipal).gid();
            this.setOwners(-1, n);
        }
    }

    private class BasicFileAttributeViewImpl
    implements BasicFileAttributeView {
        final UnixPath file;
        final boolean followLinks;

        BasicFileAttributeViewImpl(UnixPath unixPath, boolean bl) {
            this.file = unixPath;
            this.followLinks = bl;
        }

        int open() throws IOException {
            int n = UnixConstants.O_RDONLY;
            if (!this.followLinks) {
                n |= UnixConstants.O_NOFOLLOW;
            }
            try {
                return UnixNativeDispatcher.openat(UnixSecureDirectoryStream.this.dfd, this.file.asByteArray(), n, 0);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
                return -1;
            }
        }

        private void checkWriteAccess() {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (this.file == null) {
                    UnixSecureDirectoryStream.this.ds.directory().checkWrite();
                } else {
                    UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkWrite();
                }
            }
        }

        @Override
        public String name() {
            return "basic";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BasicFileAttributes readAttributes() throws IOException {
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    if (this.file == null) {
                        UnixSecureDirectoryStream.this.ds.directory().checkRead();
                    } else {
                        UnixSecureDirectoryStream.this.ds.directory().resolve(this.file).checkRead();
                    }
                }
                try {
                    UnixFileAttributes unixFileAttributes = this.file == null ? UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd) : UnixFileAttributes.get(UnixSecureDirectoryStream.this.dfd, this.file, this.followLinks);
                    BasicFileAttributes basicFileAttributes = unixFileAttributes.asBasicFileAttributes();
                    return basicFileAttributes;
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(this.file);
                    BasicFileAttributes basicFileAttributes = null;
                    UnixSecureDirectoryStream.this.ds.readLock().unlock();
                    return basicFileAttributes;
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimes(FileTime fileTime, FileTime fileTime2, FileTime fileTime3) throws IOException {
            this.checkWriteAccess();
            UnixSecureDirectoryStream.this.ds.readLock().lock();
            try {
                if (!UnixSecureDirectoryStream.this.ds.isOpen()) {
                    throw new ClosedDirectoryStreamException();
                }
                int n = this.file == null ? UnixSecureDirectoryStream.this.dfd : this.open();
                try {
                    if (fileTime == null || fileTime2 == null) {
                        try {
                            UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(n);
                            if (fileTime == null) {
                                fileTime = unixFileAttributes.lastModifiedTime();
                            }
                            if (fileTime2 == null) {
                                fileTime2 = unixFileAttributes.lastAccessTime();
                            }
                        }
                        catch (UnixException unixException) {
                            unixException.rethrowAsIOException(this.file);
                        }
                    }
                    try {
                        UnixNativeDispatcher.futimes(n, fileTime2.to(TimeUnit.MICROSECONDS), fileTime.to(TimeUnit.MICROSECONDS));
                    }
                    catch (UnixException unixException) {
                        unixException.rethrowAsIOException(this.file);
                    }
                }
                finally {
                    if (this.file != null) {
                        UnixNativeDispatcher.close(n);
                    }
                }
            }
            finally {
                UnixSecureDirectoryStream.this.ds.readLock().unlock();
            }
        }
    }
}

