/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.psc.shared.message.FieldName;
import de.plans.psc.shared.message.RequestID;
import de.plans.psc.shared.message.RequestStatus;
import de.plans.psc.shared.message.SegmentHeaderEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Set;

public class ServerSegmentHeader {
    public static final long ResponseBytesTotalLength_Unkown = -1L;
    public static final long RequestBytesMissingBytesStartIndex_Undefined = -1L;
    private final RequestID requestID;
    private final RequestStatus requestStatus;
    private final RequestID highestKnownRequestID;
    @Deprecated
    private final Set<RequestID> activeRequests;
    private final long responseBytesStartIndex;
    private final long responseBytesSegmentLength;
    private final long responseBytesTotalLength;
    private final long requestBytesMissingBytesStartIndex;
    private final long requestBytesMissingBytesLength;

    public ServerSegmentHeader(RequestID requestID, RequestStatus requestStatus, RequestID highestKnownRequestID, Set<RequestID> activeRequests, long responseBytesStartIndex, long responseBytesSegmentLength, long responseBytesTotalLength, long requestBytesMissingBytesStartIndex, long requestBytesMissingBytesLength) {
        this.requestID = requestID;
        this.requestStatus = requestStatus;
        this.highestKnownRequestID = highestKnownRequestID;
        this.activeRequests = activeRequests;
        this.responseBytesStartIndex = responseBytesStartIndex;
        this.responseBytesSegmentLength = responseBytesSegmentLength;
        this.responseBytesTotalLength = responseBytesTotalLength;
        this.requestBytesMissingBytesStartIndex = requestBytesMissingBytesStartIndex;
        this.requestBytesMissingBytesLength = requestBytesMissingBytesLength;
    }

    public ServerSegmentHeader(SegmentHeaderEncoder.RawSegmentHeaderData rawSegmentHeaderData) {
        LinkedHashMap<FieldName, String> fieldValueMap = rawSegmentHeaderData.getStandardFields();
        assert (rawSegmentHeaderData.getExtraFields().size() == 0);
        this.requestID = SegmentHeaderEncoder.decodeField_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_RequestID));
        this.requestStatus = SegmentHeaderEncoder.decodeField_RequestStatus(fieldValueMap.get(FieldName.FIELD_NAME_RequestStatus));
        this.highestKnownRequestID = SegmentHeaderEncoder.decodeField_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_HighestKnownRequestID));
        this.activeRequests = SegmentHeaderEncoder.decodeField_Set_RequestID(fieldValueMap.get(FieldName.FIELD_NAME_ActiveRequests));
        this.responseBytesStartIndex = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_ResponseBytesStartIndex));
        this.responseBytesSegmentLength = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_ResponseBytesSegmentLength));
        this.responseBytesTotalLength = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_ResponseBytesTotalLength));
        this.requestBytesMissingBytesStartIndex = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesMissingBytesStartIndex));
        this.requestBytesMissingBytesLength = SegmentHeaderEncoder.decodeField_Long(fieldValueMap.get(FieldName.FIELD_NAME_RequestBytesMissingBytesLength));
    }

    public static ServerSegmentHeader parseStreamEncodedHeader(InputStream inputStream) throws IOException, SegmentHeaderEncoder.ExInvalidSegmentData {
        SegmentHeaderEncoder.RawSegmentHeaderData rawSegmentHeaderData = SegmentHeaderEncoder.decodeSegment(inputStream);
        return new ServerSegmentHeader(rawSegmentHeaderData);
    }

    public void serializeIntoStream(OutputStream responseStream) throws IOException {
        LinkedHashMap<FieldName, String> fieldValueMap = new LinkedHashMap<FieldName, String>();
        fieldValueMap.put(FieldName.FIELD_NAME_RequestID, SegmentHeaderEncoder.encodeField_RequestID(this.requestID));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestStatus, SegmentHeaderEncoder.encodeField_RequestStatus(this.requestStatus));
        fieldValueMap.put(FieldName.FIELD_NAME_HighestKnownRequestID, SegmentHeaderEncoder.encodeField_RequestID(this.highestKnownRequestID));
        fieldValueMap.put(FieldName.FIELD_NAME_ActiveRequests, SegmentHeaderEncoder.encodeField_Set_RequestID(this.activeRequests));
        fieldValueMap.put(FieldName.FIELD_NAME_ResponseBytesStartIndex, SegmentHeaderEncoder.encodeField_Long(this.responseBytesStartIndex));
        fieldValueMap.put(FieldName.FIELD_NAME_ResponseBytesSegmentLength, SegmentHeaderEncoder.encodeField_Long(this.responseBytesSegmentLength));
        fieldValueMap.put(FieldName.FIELD_NAME_ResponseBytesTotalLength, SegmentHeaderEncoder.encodeField_Long(this.responseBytesTotalLength));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesMissingBytesStartIndex, SegmentHeaderEncoder.encodeField_Long(this.requestBytesMissingBytesStartIndex));
        fieldValueMap.put(FieldName.FIELD_NAME_RequestBytesMissingBytesLength, SegmentHeaderEncoder.encodeField_Long(this.requestBytesMissingBytesLength));
        responseStream.write(SegmentHeaderEncoder.encodeSegment(new SegmentHeaderEncoder.RawSegmentHeaderData(fieldValueMap, null)));
    }

    public RequestID getRequestID() {
        return this.requestID;
    }

    public RequestStatus getRequestStatus() {
        return this.requestStatus;
    }

    public RequestID getHighestKnownRequestID() {
        return this.highestKnownRequestID;
    }

    public Set<RequestID> getActiveRequests() {
        return this.activeRequests;
    }

    public long getResponseBytesStartIndex() {
        return this.responseBytesStartIndex;
    }

    public long getResponseBytesSegmentLength() {
        return this.responseBytesSegmentLength;
    }

    public long getResponseBytesTotalLength() {
        return this.responseBytesTotalLength;
    }

    public long getRequestBytesMissingBytesStartIndex() {
        return this.requestBytesMissingBytesStartIndex;
    }

    public long getRequestBytesMissingBytesLength() {
        return this.requestBytesMissingBytesLength;
    }
}

