/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOUpdateFileInfo
extends EOEncodableObject {
    private static final ILogger logger = Logger.getLogger(EOUpdateFileInfo.class);
    public static final String XML_NAME = "psc.updatesitefileinfo";
    private static final String ATTR_TAG_AVAILABLE = "available";
    private static final String ATTR_TAG_TRANSFER_ID = "transferID";
    private static final String ATTR_TAG_CONTENT_LENGTH = "contentLength";
    private static final String ATTR_TAG_LAST_MODIFIED = "lastModified";
    public static final String ATTR_VAL_AVAILABLE_AVAILABLE = "available";
    public static final String ATTR_VAL_AVAILABLE_NOT_AVAILABLE = "notAvailable";
    public static final String ATTR_VAL_UNKNOWN_OR_NULL = "<valueUnkownOrNull>";
    private String available = "notAvailable";
    private String transferID = null;
    private Long contentLength = null;
    private Long lastModified = null;

    public EOUpdateFileInfo() {
        super(XML_NAME);
    }

    public EOUpdateFileInfo(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, "available", this.getAvailable());
        this.appendAttrToXML(writeContext, ATTR_TAG_TRANSFER_ID, this.getTransferID() == null ? ATTR_VAL_UNKNOWN_OR_NULL : this.getTransferID());
        this.appendAttrToXML(writeContext, ATTR_TAG_LAST_MODIFIED, this.getLastModified() == null ? ATTR_VAL_UNKNOWN_OR_NULL : this.getLastModified().toString());
        this.appendAttrToXML(writeContext, ATTR_TAG_CONTENT_LENGTH, this.getContentLength() == null ? ATTR_VAL_UNKNOWN_OR_NULL : this.getContentLength().toString());
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals("available")) {
            this.setAvailable(value);
        } else if (name.equals(ATTR_TAG_TRANSFER_ID)) {
            this.setTransferID(value);
        } else if (name.equals(ATTR_TAG_LAST_MODIFIED)) {
            this.setLastModified(value);
        } else if (name.equals(ATTR_TAG_CONTENT_LENGTH)) {
            this.setContentLength(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getAvailable() {
        return this.available;
    }

    public boolean isAvailableOnUpdateSite() {
        return "available".equals(this.available);
    }

    public void setAvailable(String available) {
        this.available = available;
    }

    public String getTransferID() {
        return this.transferID;
    }

    public void setTransferID(String transferID) {
        this.transferID = transferID;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(String contentLength) {
        if (ATTR_VAL_UNKNOWN_OR_NULL.equals(contentLength)) {
            this.contentLength = null;
        } else {
            try {
                this.contentLength = Long.parseLong(contentLength);
            }
            catch (NumberFormatException nfe) {
                this.contentLength = null;
                logger.error("Illegal contentLength value detected.", nfe);
            }
        }
    }

    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        if (ATTR_VAL_UNKNOWN_OR_NULL.equals(lastModified)) {
            this.lastModified = null;
        } else {
            try {
                this.lastModified = Long.parseLong(lastModified);
            }
            catch (NumberFormatException nfe) {
                this.lastModified = null;
                logger.error("Illegal lastModified value detected.", nfe);
            }
        }
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }
}

