/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.shared.message;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.psc.shared.message.IPermissionOwner;

public class EOGroup
extends EOEncodableObject
implements IPermissionOwner {
    public static final String GROUP_NAME_ADMINS = "Administrators";
    public static final String GROUP_NAME_EVERYONE = "Everyone";
    public static final String XML_NAME = "Group";
    private static final String ATTR_TAG_GROUP_NAME = "groupName";
    private static final String ATTR_TAG_DISPLAY_NAME = "displayName";
    private static final String ATTR_TAG_DESCRIPTION = "description";
    private String groupName;
    private String displayName;
    private String description;

    public EOGroup() {
        super(XML_NAME);
    }

    public EOGroup(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public EOGroup(EOGroup group) {
        super(XML_NAME);
        this.groupName = group.groupName;
        this.displayName = group.displayName;
        this.description = group.description;
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendAttrToXML(writeContext, ATTR_TAG_GROUP_NAME, this.getGroupName());
        this.appendAttrToXML(writeContext, ATTR_TAG_DISPLAY_NAME, this.getDisplayName());
        this.appendAttrToXML(writeContext, ATTR_TAG_DESCRIPTION, this.getDescription());
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean knownAttribute = true;
        if (name.equals(ATTR_TAG_GROUP_NAME)) {
            this.setGroupName(value);
        } else if (name.equals(ATTR_TAG_DISPLAY_NAME)) {
            this.setDisplayName(value);
        } else if (name.equals(ATTR_TAG_DESCRIPTION)) {
            this.setDescription(value);
        } else {
            knownAttribute = false;
        }
        return knownAttribute;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public EOGroup copy() {
        EOGroup copy = new EOGroup();
        copy.setDescription(this.description);
        copy.setGroupName(this.groupName);
        copy.setDisplayName(this.displayName);
        return copy;
    }

    public String getGroupName() {
        if (this.groupName == null) {
            return "";
        }
        return this.groupName;
    }

    @Override
    public String getPermissionOwnerID() {
        return this.getGroupName();
    }

    @Override
    public int getPermissionOwnerType() {
        return 1;
    }

    @Override
    public String getPermissionOwnerName() {
        return String.valueOf(this.getDisplayName()) + "   (" + this.getGroupName() + ")";
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return "";
        }
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setGroupName(String gname) {
        this.groupName = gname;
    }

    public void setDisplayName(String dname) {
        this.displayName = dname;
    }

    public void setDescription(String description) {
        this.description = description == null ? "" : description;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            if (obj instanceof EOGroup) {
                EOGroup group = (EOGroup)obj;
                return group.getGroupName().equals(this.getGroupName());
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getGroupName().hashCode();
    }
}

