/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.model;

import de.plans.psc.shared.message.EOGroup;

public class UserGroup {
    private final EOGroup groupData;
    private boolean selected = false;
    private boolean enabled = true;

    public UserGroup() {
        this.groupData = new EOGroup();
    }

    public UserGroup(EOGroup groupData) {
        this.groupData = groupData;
    }

    public EOGroup getEOGroup() {
        return this.groupData;
    }

    public boolean existsInDatabase() {
        return true;
    }

    public boolean hasDescription() {
        return this.groupData.getDescription() != null && this.groupData.getDescription().length() != 0;
    }

    public boolean hasDisplayName() {
        return this.groupData.getDisplayName() != null && this.groupData.getDisplayName().length() != 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserGroup other = (UserGroup)obj;
        if (this.getGroupName() == null) {
            return other.getGroupName() == null;
        }
        return this.getGroupName().equals(other.getGroupName());
    }

    public int hashCode() {
        assert (false) : "Hashing not supported / implemented most inefficently.";
        return 0;
    }

    public String getGroupName() {
        return this.groupData.getGroupName();
    }

    public String getDisplayName() {
        return this.groupData.getDisplayName();
    }

    public String getDescription() {
        return this.groupData.getDescription();
    }

    public EOGroup getGroupData() {
        return this.groupData;
    }

    public void setGroupName(String groupName) {
        this.groupData.setGroupName(groupName);
    }

    public void setDisplayName(String displayName) {
        this.groupData.setDisplayName(displayName);
    }

    public void setDescription(String description) {
        this.groupData.setDescription(description);
    }

    public boolean isSuperGroup() {
        boolean isSuperGroup = this.getGroupName().compareTo("Administrators") == 0 || this.getGroupName().compareTo("Everyone") == 0;
        return isSuperGroup;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

