/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.model;

import de.plans.lib.xml.encoding.EOList;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.model.GroupWithUsers;
import de.plans.psc.client.model.PSCListDataEvent;
import de.plans.psc.client.model.PSCListDataListener;
import de.plans.psc.client.model.PSCListModel;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOGroup;
import de.plans.psc.shared.message.EOGroupAndUsers;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ui.internal.misc.StringMatcher;

public class GroupListModel
implements PSCListModel {
    protected List groups = new ArrayList();
    private final List listeners = new ArrayList();

    public void clear() {
        this.groups.clear();
    }

    @Override
    public int getSize() {
        return this.groups.size();
    }

    public UserGroup getElement(int index) {
        return (UserGroup)this.groups.get(index);
    }

    @Override
    public Object getElementAt(int index) {
        return this.groups.get(index);
    }

    public Object[] toArray() {
        return this.groups.toArray();
    }

    public Object set(int index, UserGroup o) {
        return this.groups.set(index, o);
    }

    public int indexOf(Object priv) {
        return this.groups.indexOf(priv);
    }

    public boolean removeElement(UserGroup group) {
        int index = this.groups.indexOf(group);
        boolean success = this.groups.remove(group);
        if (success) {
            this.postRemoveEventToListeners(index, index);
        }
        return success;
    }

    public void setGroups(List groups) {
        this.groups = groups;
        this.postChangeEventToListeners(0, groups.size());
    }

    public void loadGroupsFromServer(String serverID) throws ServerNotAvailableException, UnknownServerException, EXServerException, LoginCanceledException {
        EOClientRequest request = new EOClientRequest("User", "GetAllGroups", null);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
        this.groups.clear();
        if (response != null) {
            EOList list = (EOList)response.getResponseData();
            int i = 0;
            while (i < list.size()) {
                this.addElement(new UserGroup((EOGroup)list.get(i)));
                ++i;
            }
        }
        this.postChangeEventToListeners(0, this.groups.size());
    }

    public void loadGroupsWithUsersAndPrivilegesFromServer(String serverID) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        EOClientRequest request = new EOClientRequest("User", "GetAllGroupsWithUsers", null);
        EOServerResponse response = PSCClientServiceFacade.getFacade().sendRequest(serverID, request);
        this.groups.clear();
        if (response != null) {
            EOList list = (EOList)response.getResponseData();
            int i = 0;
            while (i < list.size()) {
                EOGroupAndUsers groupUsers = (EOGroupAndUsers)list.get(i);
                GroupWithUsers group = new GroupWithUsers();
                group.setGroupName(groupUsers.getGroup().getGroupName());
                group.setDisplayName(groupUsers.getGroup().getDisplayName());
                group.setDescription(groupUsers.getGroup().getDescription());
                group.setUsers(groupUsers.getUsers());
                this.addElement(group);
                ++i;
            }
        }
        this.postChangeEventToListeners(0, this.groups.size());
    }

    public boolean addElement(UserGroup group) {
        boolean inserted = false;
        String insertString = group.getGroupName().toLowerCase();
        if (insertString.length() == 0) {
            return false;
        }
        int i = 0;
        i = 0;
        while (i < this.groups.size()) {
            int j = ((UserGroup)this.groups.get(i)).getGroupName().toLowerCase().compareTo(insertString);
            if (j == 0) {
                return false;
            }
            if (j > 0) {
                this.groups.add(i, group);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            this.groups.add(group);
        }
        this.postAddEventToListeners(i, i);
        return true;
    }

    public GroupWithUsers find(String searchString) {
        StringMatcher sm = new StringMatcher(String.valueOf(searchString) + "*", true, false);
        for (GroupWithUsers group : this.groups) {
            if (!sm.match(group.getGroupName())) continue;
            return group;
        }
        return null;
    }

    public String[] getGroupNames() {
        String[] names = new String[this.groups.size()];
        int i = 0;
        while (i < names.length) {
            try {
                names[i] = ((UserGroup)this.groups.get(i)).getGroupName();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            ++i;
        }
        return names;
    }

    public void clearSelectedFlag() {
        int i = 0;
        while (i < this.groups.size()) {
            ((UserGroup)this.groups.get(i)).setSelected(false);
            ++i;
        }
    }

    private void postAddEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.intervalAdded(new PSCListDataEvent(this, 1, index0, index1));
            ++i;
        }
    }

    private void postRemoveEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.intervalRemoved(new PSCListDataEvent(this, 2, index0, index1));
            ++i;
        }
    }

    private void postChangeEventToListeners(int index0, int index1) {
        int i = 0;
        while (i < this.listeners.size()) {
            PSCListDataListener l = (PSCListDataListener)this.listeners.get(i);
            l.contentsChanged(new PSCListDataEvent(this, 0, index0, index1));
            ++i;
        }
    }

    @Override
    public void addListDataListener(PSCListDataListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListDataListener(PSCListDataListener l) {
        this.listeners.remove(l);
    }
}

