/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dump;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.eclipse.file.tmp.SessionTempDirectoryManager;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.util.Zip;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.psc.client.dump.DumpFileHelper;
import de.plans.psc.shared.DumpFileAccessException;
import de.plans.psc.shared.ServerDumpFileAccess;
import de.plans.psc.shared.message.EOVersionFileContent;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class ServerDumpFileAccess_ForClient
extends ServerDumpFileAccess {
    private static final ILogger logger = Logger.getLogger(ServerDumpFileAccess_ForClient.class);

    public ServerDumpFileAccess_ForClient(File serverDumpFile) throws DumpFileAccessException {
        super(serverDumpFile);
        this.init();
        this.migrateDumpFile();
    }

    public void resetVersionInformation(EOVersionFileContent newVersions) throws DumpFileAccessException {
        this.checkState();
        EOVersionFileContent versions = this.getVersionFileContent();
        if (versions == null) {
            versions = new EOVersionFileContent("psc.server-dump", Collections.emptyMap());
            this.setVersions(versions);
        } else {
            versions.clearVersions();
        }
        versions.putAllVersions(newVersions);
        int baseVersion = this.getBaseVersion();
        if (baseVersion != -1) {
            versions.putVersion("com.arcway.psc", baseVersion);
        }
    }

    public void updateVersionInformation(EOVersionFileContent newVersions) throws DumpFileAccessException {
        this.checkState();
        EOVersionFileContent versions = this.getVersionFileContent();
        if (versions == null) {
            versions = new EOVersionFileContent("psc.server-dump", Collections.emptyMap());
            this.setVersions(versions);
        }
        versions.putAllVersions(newVersions);
        int baseVersion = this.getBaseVersion();
        if (baseVersion != -1) {
            versions.putVersion("com.arcway.psc", baseVersion);
        }
    }

    public void saveToTarget(File targetFile) throws DumpFileAccessException {
        this.checkState();
        try {
            File versionFile = new File(this.getRootDirectoryOfUnzippedServerDumpFile(), "versions.xml");
            if (versionFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory(versionFile);
            }
            this.getVersionFileContent().writeToFile(versionFile);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't update version file.", jeriE);
            throw new DumpFileAccessException(jeriE);
        }
        catch (IOException ioE) {
            logger.error("Can't update version file.", ioE);
            throw new DumpFileAccessException(ioE);
        }
        this.rezipToTarget(targetFile);
        this.dispose_internal();
    }

    @Override
    protected File createRootDirectoryOfUnzippedServerDumpFile() throws DumpFileAccessException {
        try {
            return SessionTempDirectoryManager.createSessionTempSubDirectory((String)"cockpit_serverdump_tmp");
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't create a temp directory for extracting a server dump file.", jeriE);
            throw new DumpFileAccessException(jeriE);
        }
    }

    @Override
    protected EncodableObjectBase readVersionFromFile(File sourceFile) throws DumpFileAccessException {
        try {
            return DumpFileHelper.readVersionsFromFile(sourceFile);
        }
        catch (EXDecoderException exDE) {
            throw new DumpFileAccessException(exDE);
        }
        catch (IOException ioE) {
            throw new DumpFileAccessException(ioE);
        }
    }

    private void migrateDumpFile() {
    }

    private void rezipToTarget(File targetFile) throws DumpFileAccessException {
        try {
            if (targetFile.exists()) {
                FileHelper.deleteExistingFileOrDirectory(targetFile);
            }
            Zip.createZipFile(this.getRootDirectoryOfUnzippedServerDumpFile(), targetFile);
        }
        catch (IOException ioE) {
            logger.error("Can't rezip server dump file to target directory (" + targetFile.getAbsolutePath() + ").", ioE);
            throw new DumpFileAccessException(ioE);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.error("Can't rezip server dump file to target directory (" + targetFile.getAbsolutePath() + "). Can't delete existing target file.", jeriE);
            throw new DumpFileAccessException(jeriE);
        }
    }
}

