/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import com.arcway.lib.io.FileHelper;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.parameter.XMLConfigParameterMgr;
import de.plans.psc.client.PSCAbstractClientFactory;
import de.plans.psc.client.PSCClientLogMgr;
import de.plans.psc.client.dialogs.swt.Messages;
import de.plans.psc.client.eclipseplugin.EclipsePlugin;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class NewLoggerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int LOG_FILE_LENGTH_RESOLUTION = 1024;
    private PSCClientLogMgr.LoggingParameterSet loggingParameterSet;
    private Text fldFileLength;
    private Text fldLogFilePath;
    private Button btnBrowseLogFile;
    private long lastFileLength;

    protected Control createContents(Composite parent1) {
        Composite base = new Composite(parent1, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout());
        Group logGrp = new Group(base, 32);
        logGrp.setText(Messages.getString("FMCAPreferencePage.Log_File_Configuration_5"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        logGrp.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        logGrp.setLayoutData((Object)gridData);
        Label logFileLabel = new Label((Composite)logGrp, 0);
        logFileLabel.setText(Messages.getString("FMCAPreferencePage.Log_file_6"));
        logFileLabel.setLayoutData((Object)new GridData(128));
        this.fldLogFilePath = new Text((Composite)logGrp, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fldLogFilePath.setLayoutData((Object)gridData);
        this.btnBrowseLogFile = new Button((Composite)logGrp, 8);
        this.btnBrowseLogFile.setText(Messages.getString("FMCAPreferencePage.Browse_7"));
        this.btnBrowseLogFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewLoggerPreferencePage.this.getLogFile();
            }
        });
        Label logFileLengthLabel = new Label((Composite)logGrp, 0);
        logFileLengthLabel.setText(Messages.getString("FMCAPreferencePage.max._log_file_size_8"));
        this.fldFileLength = new Text((Composite)logGrp, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        gridData.widthHint = 50;
        this.fldFileLength.setLayoutData((Object)gridData);
        this.fldFileLength.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent arg) {
                while (NewLoggerPreferencePage.this.fldFileLength.getText() != null && NewLoggerPreferencePage.this.fldFileLength.getText().length() > 0) {
                    Point selection = null;
                    try {
                        selection = NewLoggerPreferencePage.this.fldFileLength.getSelection();
                        int fileLength = Integer.parseInt(NewLoggerPreferencePage.this.fldFileLength.getText());
                        if (fileLength < 0x1FFFFF) {
                            NewLoggerPreferencePage.this.lastFileLength = fileLength;
                            break;
                        }
                        NewLoggerPreferencePage.this.fldFileLength.setText(Long.toString(NewLoggerPreferencePage.this.lastFileLength));
                        if (selection == null) break;
                        NewLoggerPreferencePage.this.fldFileLength.setSelection(selection);
                        break;
                    }
                    catch (NumberFormatException e) {
                        NewLoggerPreferencePage.this.fldFileLength.setText(Long.toString(NewLoggerPreferencePage.this.lastFileLength));
                        if (selection == null) continue;
                        NewLoggerPreferencePage.this.fldFileLength.setSelection(selection);
                    }
                }
            }
        });
        Label logFileLengthUnitLabel = new Label((Composite)logGrp, 0);
        logFileLengthUnitLabel.setText(Messages.getString("FMCAPreferencePage.(kb)_9"));
        this.initializeValues();
        return base;
    }

    private void initializeValues() {
        if (this.loggingParameterSet != null) {
            if (this.loggingParameterSet.getLogFilePath() != null) {
                this.fldLogFilePath.setText(this.loggingParameterSet.getLogFilePath());
            }
            this.lastFileLength = this.loggingParameterSet.getMaxFileLength() / 1024L;
            this.fldFileLength.setText(Long.toString(this.lastFileLength));
        }
    }

    public void init(IWorkbench workbench) {
        XMLConfigParameterMgr parameterMgr = EclipsePlugin.getDefault().getClientServiceFacade().getParameterManager();
        this.loggingParameterSet = (PSCClientLogMgr.LoggingParameterSet)parameterMgr.getSubtree(PSCClientLogMgr.LoggingParameterSet.XML_NAME);
    }

    protected void performDefaults() {
        this.fldLogFilePath.setText(".");
        this.fldFileLength.setText("64000");
    }

    private void getLogFile() {
        File tempFile = this.getFile(new File(this.fldLogFilePath.getText()));
        if (tempFile != null) {
            this.fldLogFilePath.setText(tempFile.getAbsolutePath());
        }
    }

    private File getFile(File startingDirectory) {
        String file;
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        if (startingDirectory != null) {
            dialog.setFileName(startingDirectory.getPath());
        }
        if ((file = dialog.open()) != null && (file = file.trim()).length() > 0) {
            return new File(file);
        }
        return null;
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    protected void performApply() {
        this.setMessage(null, 3);
        String newLogFile = this.fldLogFilePath.getText().trim();
        File logFile = new File(newLogFile);
        File parent = logFile.getParentFile();
        boolean parentCreationFailed = false;
        if (parent != null && !parent.exists()) {
            try {
                FileHelper.ensureDirectoryExistance(parent);
            }
            catch (JvmExternalResourceInteractionException e) {
                parentCreationFailed = true;
            }
        }
        boolean logFileIsDirectory = logFile.isDirectory();
        boolean parentCanBeWritten = true;
        if (parent != null) {
            parentCanBeWritten = parent.canWrite();
        }
        boolean fileCanBeWritten = true;
        if (logFile.exists()) {
            fileCanBeWritten = logFile.canWrite();
        }
        if (logFileIsDirectory || parentCreationFailed || !parentCanBeWritten || !fileCanBeWritten) {
            newLogFile = this.loggingParameterSet.getLogFilePath();
            this.setMessage(String.valueOf(Messages.getString("NewLoggerPreferencePage.Unable_to_write_logfile_to")) + logFile.getAbsolutePath(), 3);
        } else {
            newLogFile = logFile.getAbsolutePath();
        }
        this.fldLogFilePath.setText(newLogFile);
        boolean changed = !this.loggingParameterSet.getLogFilePath().equals(this.fldLogFilePath.getText());
        this.loggingParameterSet.setLogFilePath(newLogFile);
        String length = this.fldFileLength.getText();
        if (length != null) {
            int logFileLength = Integer.parseInt(this.fldFileLength.getText());
            long newLogLength = logFileLength * 1024;
            changed = changed || newLogLength != this.loggingParameterSet.getMaxFileLength();
            this.loggingParameterSet.setMaxFileLength(newLogLength);
        }
        if (changed) {
            PSCAbstractClientFactory.getClientFactory().getClientLogMgr().setup();
        }
    }
}

