/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.swt;

import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.dialogs.CtrlLogin;
import de.plans.psc.client.dialogs.DlgLoginIF;
import de.plans.psc.client.dialogs.swt.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DlgLogin
extends TitleAreaDialog
implements DlgLoginIF {
    private static final String SHOW_DETAILS = Messages.getString("DlgLogin.Details_>>_1");
    private static final String HIDE_DETAILS = Messages.getString("DlgLogin.Details_<<_2");
    private static final int LOGIN_BTN_ID = 900;
    private static final int DETAILS_BTN_ID = 901;
    private CtrlLogin ctrl;
    private boolean showDetails = false;
    private final Shell shell;
    private Button btnLogin;
    private Button checkRememberPassword;
    private Composite rootArea;
    private Label lblPassword;
    private Label lblUserName;
    private Text fldPassword;
    private Text fldUserName;
    private String message;
    private Composite buttonBarCompositeWithVaryingContent;
    private StackLayout buttonBarCompositeStackLayout;
    private boolean doLogin = false;

    public DlgLogin(Shell p_shell) {
        super(p_shell);
        this.shell = p_shell;
        this.setBlockOnOpen(true);
    }

    public void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("DlgLogin.Login_3"));
        newShell.forceActive();
        newShell.forceFocus();
        Platform.endSplash();
    }

    protected Control createDialogArea(Composite parent) {
        this.rootArea = new Composite(parent, 0);
        this.rootArea.setLayout((Layout)new GridLayout());
        this.initComponents(this.rootArea);
        return this.rootArea;
    }

    private void initComponents(Composite dialogRootArea) {
        GridData gridData = new GridData(1808);
        gridData.widthHint = 450;
        dialogRootArea.setLayoutData((Object)gridData);
        Composite pnlRight = new Composite(dialogRootArea, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 1;
        pnlRight.setLayout((Layout)gl);
        gridData = new GridData(1808);
        pnlRight.setLayoutData((Object)gridData);
        Composite pnlFields = new Composite(pnlRight, 0);
        gridData = new GridData(1808);
        pnlFields.setLayoutData((Object)gridData);
        gl = new GridLayout();
        gl.numColumns = 2;
        pnlFields.setLayout((Layout)gl);
        this.lblUserName = new Label(pnlFields, 0);
        this.lblUserName.setText(Messages.getString("DlgLogin.User_name__4"));
        this.fldUserName = new Text(pnlFields, 2052);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        this.fldUserName.setLayoutData((Object)gridData);
        this.fldUserName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlgLogin.this.updateLoginButtonEnablement();
            }
        });
        this.fldUserName.setFocus();
        this.lblPassword = new Label(pnlFields, 0);
        this.lblPassword.setText(Messages.getString("DlgLogin.Password__5"));
        this.fldPassword = new Text(pnlFields, 2052);
        gridData = new GridData(768);
        this.fldPassword.setLayoutData((Object)gridData);
        this.fldPassword.setEchoChar('*');
        this.fldPassword.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DlgLogin.this.updateLoginButtonEnablement();
            }
        });
        new Label(pnlFields, 0);
        this.checkRememberPassword = new Button(pnlFields, 32);
        this.checkRememberPassword.setText(Messages.getString("DlgLogin.Remember_password_6"));
        gridData = new GridData(4);
        this.checkRememberPassword.setLayoutData((Object)gridData);
    }

    protected Control createButtonBar(Composite parent) {
        this.buttonBarCompositeWithVaryingContent = new Composite(parent, 0);
        this.buttonBarCompositeWithVaryingContent.setLayoutData((Object)new GridData(768));
        this.buttonBarCompositeStackLayout = new StackLayout();
        this.buttonBarCompositeStackLayout.marginHeight = 0;
        this.buttonBarCompositeStackLayout.marginWidth = 0;
        this.buttonBarCompositeWithVaryingContent.setLayout((Layout)this.buttonBarCompositeStackLayout);
        this.buttonBarCompositeStackLayout.topControl = this.createButtonBarWithoutDetails(this.buttonBarCompositeWithVaryingContent);
        this.init();
        return this.buttonBarCompositeWithVaryingContent;
    }

    private Composite createButtonBarWithoutDetails(Composite parent) {
        Composite buttonBarComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        buttonBarComposite.setLayout((Layout)layout);
        Composite buttonComposite = new Composite(buttonBarComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(896);
        buttonComposite.setLayoutData((Object)data);
        super.createButtonBar(buttonComposite);
        return buttonBarComposite;
    }

    private Composite createButtonBarWithDetails(Composite parent, List[] moreInfoTexts) {
        Composite buttonBarComposite = this.createButtonBarWithoutDetails(parent);
        this.createDetailsControls(buttonBarComposite, moreInfoTexts);
        return buttonBarComposite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.btnLogin = this.createButton(parent, 900, Messages.getString("DlgLogin.Login_10"), true);
        this.getShell().setDefaultButton(this.btnLogin);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.showDetails) {
            this.createButton(parent, 901, HIDE_DETAILS, false);
        } else {
            this.createButton(parent, 901, SHOW_DETAILS, false);
        }
    }

    @Override
    public void construct(CtrlLogin ctrlLogin) {
        this.ctrl = ctrlLogin;
    }

    public void buttonPressed(int buttonID) {
        switch (buttonID) {
            case 1: {
                this.cancel();
                this.cancelPressed();
                break;
            }
            case 900: {
                this.login();
                this.okPressed();
                break;
            }
            case 901: {
                this.showMoreInfo();
                break;
            }
        }
    }

    private void cancel() {
        this.doLogin = false;
    }

    private void login() {
        this.doLogin = true;
        this.ctrl.setUsername(this.fldUserName.getText());
        this.ctrl.setPassword(this.fldPassword.getText());
        this.ctrl.setRememberPassword(this.checkRememberPassword.getSelection());
    }

    private void showMoreInfo() {
        this.showDetails = !this.showDetails;
        Composite buttonBarComposite = this.showDetails ? this.createButtonBarWithDetails(this.buttonBarCompositeWithVaryingContent, this.getMoreInfoTexts()) : this.createButtonBarWithoutDetails(this.buttonBarCompositeWithVaryingContent);
        Control oldDetailsBaseComposite = this.buttonBarCompositeStackLayout.topControl;
        this.buttonBarCompositeStackLayout.topControl = buttonBarComposite;
        if (oldDetailsBaseComposite != null) {
            oldDetailsBaseComposite.dispose();
        }
        this.buttonBarCompositeWithVaryingContent.layout();
        this.getShell().pack(true);
        this.updateLoginButtonEnablement();
    }

    private void updateLoginButtonEnablement() {
        if (this.fldUserName.getText().length() == 0) {
            this.btnLogin.setEnabled(false);
        } else {
            this.btnLogin.setEnabled(true);
        }
    }

    @Override
    public boolean doLogin(String msg) {
        this.message = msg;
        this.doLogin = false;
        this.open();
        return this.doLogin;
    }

    private void init() {
        this.setTitle(String.valueOf(Messages.getString("DlgLogin.Login_on_to_Server__11")) + this.ctrl.getServerName());
        this.setMessage("");
        if (this.message == null) {
            this.setMessage(Messages.getString("DlgLogin.Please_enter_username_and_password_12"));
        } else {
            this.setMessage(this.message, 3);
        }
        this.fldUserName.setText(this.ctrl.getRememberedUserName());
        this.fldPassword.setText(this.ctrl.getRememberedPassword());
        if (this.ctrl.getRememberedUserName() == null || "".equals(this.ctrl.getRememberedUserName())) {
            this.fldUserName.selectAll();
            this.fldUserName.forceFocus();
        } else if (this.message != null || this.ctrl.getRememberedPassword() == null || "".equals(this.ctrl.getRememberedPassword())) {
            this.fldPassword.selectAll();
            this.fldPassword.forceFocus();
        } else {
            this.fldUserName.selectAll();
            this.fldUserName.forceFocus();
        }
        this.checkRememberPassword.setSelection(this.ctrl.getRememberPassword());
        this.checkRememberPassword.setEnabled(this.ctrl.getRememberPasswordAllowed());
        if (this.fldUserName.getText().length() == 0) {
            this.btnLogin.setEnabled(false);
        } else {
            this.btnLogin.setEnabled(true);
        }
    }

    private void createDetailsControls(Composite parent, List[] moreInfoTexts) {
        List labelTexts = moreInfoTexts[0];
        List valueTexts = moreInfoTexts[1];
        Composite detailsBaseComposite = new Composite(parent, 0);
        detailsBaseComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = 0;
        layout.marginBottom = this.convertVerticalDLUsToPixels(7);
        detailsBaseComposite.setLayout((Layout)layout);
        Color detailsColor = Display.getDefault().getSystemColor(29);
        Composite gridComposite = new Composite(detailsBaseComposite, 2048);
        gridComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout(2, false);
        gridComposite.setLayout((Layout)layout2);
        gridComposite.setBackground(detailsColor);
        int i = 0;
        while (i < labelTexts.size()) {
            StyledText label = new StyledText(gridComposite, 128);
            label.setText((String)labelTexts.get(i));
            label.setEditable(false);
            GridData gridData = new GridData();
            label.setLayoutData((Object)gridData);
            label.setBackground(detailsColor);
            StyledText value = new StyledText(gridComposite, 128);
            value.setText((String)valueTexts.get(i));
            value.setEditable(false);
            gridData = new GridData(4, -1, true, false);
            value.setLayoutData((Object)gridData);
            value.setBackground(detailsColor);
            ++i;
        }
    }

    private List[] getMoreInfoTexts() {
        ArrayList<String> labelTexts = new ArrayList<String>();
        ArrayList<String> valueTexts = new ArrayList<String>();
        Object detailedRequestorInfoObject = this.ctrl.getAuthenticationReceiverInfo();
        if (detailedRequestorInfoObject == null) {
            labelTexts.add("");
            valueTexts.add("-");
        } else if (detailedRequestorInfoObject instanceof String) {
            labelTexts.add(Messages.getString("DlgLogin.Details_URL"));
            valueTexts.add((String)detailedRequestorInfoObject);
        } else if (detailedRequestorInfoObject instanceof PSCAuthenticator.RequestorInfo) {
            PSCAuthenticator.RequestorInfo requestorInfo = (PSCAuthenticator.RequestorInfo)detailedRequestorInfoObject;
            labelTexts.add(Messages.getString("DlgLogin.Details_Prompt"));
            valueTexts.add(requestorInfo.getPrompt());
            labelTexts.add(Messages.getString("DlgLogin.Details_Host"));
            valueTexts.add(requestorInfo.getHost());
            labelTexts.add(Messages.getString("DlgLogin.Details_Site"));
            valueTexts.add(requestorInfo.getSite().toString());
            labelTexts.add(Messages.getString("DlgLogin.Details_Port"));
            valueTexts.add("" + requestorInfo.getPort());
            labelTexts.add(Messages.getString("DlgLogin.Details_Protocol"));
            valueTexts.add(requestorInfo.getProtocol());
            labelTexts.add(Messages.getString("DlgLogin.Details_Sheme"));
            valueTexts.add(requestorInfo.getSheme());
        } else {
            labelTexts.add(Messages.getString(""));
            valueTexts.add(detailedRequestorInfoObject.toString());
        }
        List[] moreInfoTexts = new List[]{labelTexts, valueTexts};
        return moreInfoTexts;
    }

    @Override
    public boolean displayLoginFailedNotice(String serverName, String reason) {
        String failedNoticeMessage = NLS.bind((String)Messages.getString("DlgLogin.LoginFailedNotice_Message"), (Object[])new String[]{serverName, reason});
        MessageDialog messageDialog = new MessageDialog(this.shell, Messages.getString("DlgLogin.LoginFailedNotice_Title"), null, failedNoticeMessage, 2, new String[]{IDialogConstants.RETRY_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        int buttonNr = messageDialog.open();
        return buttonNr == 0;
    }
}

