/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin.swt;

import de.plans.psc.client.dialogs.admin.swt.Messages;
import de.plans.psc.client.dialogs.admin.swt.UIPnlGroupData;
import de.plans.psc.client.model.UserGroup;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class GroupWizardGroupDataPage
extends WizardPage
implements ModifyListener {
    private UIPnlGroupData dataPanel;
    private String[] groupNames;
    private UserGroup group;

    public GroupWizardGroupDataPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        this.dataPanel = new UIPnlGroupData(composite, true);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.dataPanel.setLayoutData(gridData);
        this.dataPanel.setModifyListener(this);
        if (this.group != null) {
            this.dataPanel.setGroup(this.group);
        }
        this.setTitle(Messages.getString("GroupWizardGroupDataPage.Group_Data_1"));
        this.setDescription(Messages.getString("GroupWizardGroupDataPage.Please_enter_data_describing_the_new_group._2"));
        this.setPageComplete(false);
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    protected void setGroupNames(String[] groupNames) {
        this.groupNames = groupNames;
    }

    protected void setGroup(UserGroup group) {
        this.group = group;
        if (this.dataPanel != null) {
            this.dataPanel.setGroup(group);
        }
    }

    public void modifyText(ModifyEvent evt) {
        if (this.updateDuplicateGroupWarning()) {
            this.setPageComplete(false);
        } else if (this.dataPanel.getGroupName().length() == 0) {
            this.setMessage(Messages.getString("GroupWizardGroupDataPage.Please_enter_a_unique_group_name._3"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getGroupName().indexOf(39) != -1) {
            this.setMessage(Messages.getString("GroupWizardGroupDataPage.Do_not_use_single_quotes_in_group_name._3"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getDisplayName().length() == 0) {
            this.setMessage(Messages.getString("GroupWizardGroupDataPage.Please_enter_a_display_name_for_the_group._4"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getDisplayName().length() > 63) {
            this.setMessage(Messages.getString("GroupWizardGroupDataPage.display_name_too_long"), 3);
            this.setPageComplete(false);
        } else if (this.dataPanel.getGroupName().length() > 63) {
            this.setMessage(Messages.getString("GroupWizardGroupDataPage.group_name_too_long"), 3);
            this.setPageComplete(false);
        } else {
            this.setMessage("", 0);
            this.setPageComplete(true);
        }
    }

    private boolean updateDuplicateGroupWarning() {
        boolean duplicate = false;
        if (this.groupNames != null) {
            String groupName = this.dataPanel.getGroupName();
            String[] stringArray = this.groupNames;
            int n = this.groupNames.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                if (element.compareTo(groupName) == 0) {
                    duplicate = true;
                    this.setErrorMessage(Messages.getString("GroupWizardGroupDataPage.This_group_name_is_already_in_use_5"));
                }
                ++n2;
            }
            if (!duplicate) {
                this.setErrorMessage(null);
            }
        }
        return duplicate;
    }

    protected void fillIn(UserGroup group) {
        group.setGroupName(this.dataPanel.getGroupName());
        group.setDisplayName(this.dataPanel.getDisplayName());
        group.setDescription(this.dataPanel.getDescription());
    }
}

