/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.dialogs.admin;

import de.plans.lib.util.INotificationBusListener;
import de.plans.lib.util.Notification;
import de.plans.lib.xml.encoding.EOValue;
import de.plans.psc.client.PSCClientServiceFacade;
import de.plans.psc.client.ServerOperationsPermissionChecker;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.admin.AdminDialogFactoryIF;
import de.plans.psc.client.dialogs.admin.AssignUsersToGroupWizardIF;
import de.plans.psc.client.dialogs.admin.DlgAdminGroupsIF;
import de.plans.psc.client.dialogs.admin.EditGroupDataWizardIF;
import de.plans.psc.client.dialogs.admin.ISetPermissionsOfGroupWizard;
import de.plans.psc.client.dialogs.admin.Messages;
import de.plans.psc.client.dialogs.admin.NewGroupWizardIF;
import de.plans.psc.client.model.GroupListModel;
import de.plans.psc.client.model.GroupWithUsers;
import de.plans.psc.client.model.PermissionListModel;
import de.plans.psc.client.model.User;
import de.plans.psc.client.model.UserGroup;
import de.plans.psc.client.model.UserListModel;
import de.plans.psc.shared.PSCPermissionConstants;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOPermission;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.List;

public class CtrlAdminGroups
implements INotificationBusListener {
    private final GroupListModel groupList = new GroupListModel();
    private final PermissionListModel permissionListModel = new PermissionListModel();
    private final UserListModel userList = new UserListModel();
    private String serverID;
    private DlgAdminGroupsIF dialog;
    private final AdminDialogFactoryIF factory;
    boolean userAdmin = false;

    public CtrlAdminGroups(AdminDialogFactoryIF factory) {
        this.factory = factory;
    }

    public void construct() {
        PSCClientServiceFacade.getFacade().getNotificationBus().subscribeListener(this, "admin.admingroups", null);
    }

    @Override
    public void receiveNotification(Notification notification) {
        this.dialog = this.factory.getGroupAdminDialog();
        this.dialog.construct(this);
        this.dialog.show();
    }

    public void setServer(ServerConnection server) throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        boolean hasPermissionToAdminGroups = false;
        hasPermissionToAdminGroups = ServerOperationsPermissionChecker.isAdminUser(server.getServerID(), true);
        if (!hasPermissionToAdminGroups) {
            this.showInsufficentPrivilegesMessage();
        } else {
            this.serverID = server.getServerID();
            if (this.serverID != null) {
                this.doRetrieveGroupList();
                this.userAdmin = ServerOperationsPermissionChecker.isAdminUser(this.serverID);
                this.doRetrievePermissionList();
                this.dialog.construct(this.serverID, this.groupList, this.userAdmin, this.permissionListModel);
            }
        }
    }

    public boolean isUserRealmWritable() {
        String userRealmRepositoryType;
        boolean writeable = false;
        if (this.serverID != null && "PSC-Server".equals(userRealmRepositoryType = PSCClientServiceFacade.getFacade().getUserRealmRepositoryType(this.serverID))) {
            writeable = true;
        }
        return writeable;
    }

    public void doRefresh() {
        try {
            this.doRetrieveGroupList();
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException(e, this.serverID);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
        }
        catch (LoginCanceledException loginCanceledException) {
        }
        catch (UnknownServerException unknownServerException) {
            // empty catch block
        }
    }

    public UserGroup doAddGroup() {
        GroupWithUsers newGroup;
        block13: {
            newGroup = null;
            if (this.userAdmin && this.isUserRealmWritable()) {
                try {
                    this.doRetrieveUserList();
                    this.doRetrievePermissionList();
                    String[] names = this.groupList.getGroupNames();
                    NewGroupWizardIF wizard = this.factory.getNewGroupWizard(this.dialog);
                    wizard.construct(Messages.getString("CtrlAdminGroups.New_Group_1"), this.userList, names, this.permissionListModel);
                    int result = wizard.invokeWizard();
                    if (result != 0) break block13;
                    newGroup = wizard.getNewGroup();
                    if (newGroup != null) {
                        List deletedPermissions;
                        EOClientRequest request = new EOClientRequest("User", "AddGroup", newGroup.getEOGroup());
                        PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                        request = new EOClientRequest("User", "AddUsersToGroup", newGroup.getEOGroupUsers());
                        PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                        List addedPermissions = wizard.getAddedPermissions();
                        if (addedPermissions != null) {
                            int i = 0;
                            while (i < addedPermissions.size()) {
                                EOPermission addedPermission = (EOPermission)addedPermissions.get(i);
                                this.permissionListModel.addPermission(addedPermission);
                                ++i;
                            }
                        }
                        if ((deletedPermissions = wizard.getDeletedPermissions()) != null) {
                            int i = 0;
                            while (i < deletedPermissions.size()) {
                                EOPermission deletedPermission = (EOPermission)deletedPermissions.get(i);
                                if (!PSCPermissionConstants.isMandatoryPermission(deletedPermission)) {
                                    this.permissionListModel.deletePermission(deletedPermission);
                                }
                                ++i;
                            }
                        }
                        this.permissionListModel.commitChanges();
                        this.doRetrieveGroupList();
                        break block13;
                    }
                    this.permissionListModel.discardChanges();
                }
                catch (EXServerException e) {
                    PSCClientServiceFacade.getFacade().showException(e, this.serverID);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                }
                catch (UnknownServerException unknownServerException) {
                }
                catch (LoginCanceledException loginCanceledException) {}
            } else {
                this.showInsufficentPrivilegesMessage();
            }
        }
        return newGroup;
    }

    public void doDeleteGroup(UserGroup group) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            EOClientRequest request = new EOClientRequest("User", "DeleteGroup", new EOValue(group.getGroupName()));
            try {
                PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                List<EOPermission> deletedPermissions = this.permissionListModel.getPermissionsOfGroup(group.getGroupName());
                if (deletedPermissions != null) {
                    int i = 0;
                    while (i < deletedPermissions.size()) {
                        EOPermission deletedPermission = deletedPermissions.get(i);
                        this.permissionListModel.deletePermission(deletedPermission);
                        ++i;
                    }
                }
                this.permissionListModel.commitChanges();
                this.groupList.removeElement(group);
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (UnknownServerException unknownServerException) {
            }
            catch (LoginCanceledException loginCanceledException) {}
        } else {
            this.showInsufficentPrivilegesMessage();
        }
    }

    public UserGroup doEditGroupData(UserGroup group) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            EditGroupDataWizardIF wizard = this.factory.getEditGroupWizard(this.dialog);
            wizard.construct(group);
            wizard.invokeWizard();
            UserGroup editedGroup = wizard.getResult();
            if (editedGroup != null) {
                EOClientRequest request = new EOClientRequest("User", "UpdateGroup", editedGroup.getEOGroup());
                try {
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    this.doRetrieveGroupList();
                    group.setGroupName(editedGroup.getGroupName());
                    group.setDisplayName(editedGroup.getDisplayName());
                    group.setDescription(editedGroup.getDescription());
                }
                catch (EXServerException e) {
                    PSCClientServiceFacade.getFacade().showException(e, this.serverID);
                }
                catch (ServerNotAvailableException serverNotAvailableException) {
                }
                catch (UnknownServerException unknownServerException) {
                }
                catch (LoginCanceledException loginCanceledException) {}
            }
        } else {
            this.showInsufficentPrivilegesMessage();
        }
        return group;
    }

    public void doAssignPermissions(GroupWithUsers group) {
        try {
            if (this.userAdmin) {
                ISetPermissionsOfGroupWizard wizard = this.factory.getSetPermissionsOfGroupWizard(this.dialog);
                wizard.construct(group.getEOGroup(), this.permissionListModel);
                int result = wizard.invokeWizard();
                if (result == 0) {
                    List deletedPermissions;
                    List addedPermissions = wizard.getAddedPermissions();
                    if (addedPermissions != null) {
                        int i = 0;
                        while (i < addedPermissions.size()) {
                            EOPermission addedPermission = (EOPermission)addedPermissions.get(i);
                            this.permissionListModel.addPermission(addedPermission);
                            ++i;
                        }
                    }
                    if ((deletedPermissions = wizard.getDeletedPermissions()) != null) {
                        int i = 0;
                        while (i < deletedPermissions.size()) {
                            EOPermission deletedPermission = (EOPermission)deletedPermissions.get(i);
                            if (!PSCPermissionConstants.isMandatoryPermission(deletedPermission)) {
                                this.permissionListModel.deletePermission(deletedPermission);
                            }
                            ++i;
                        }
                    }
                    this.permissionListModel.commitChanges();
                } else {
                    this.permissionListModel.discardChanges();
                }
            }
        }
        catch (EXServerException e) {
            PSCClientServiceFacade.getFacade().showException(e, this.serverID);
        }
        catch (ServerNotAvailableException serverNotAvailableException) {
        }
        catch (UnknownServerException unknownServerException) {
        }
        catch (LoginCanceledException loginCanceledException) {
            // empty catch block
        }
    }

    public void doAssignUsers(GroupWithUsers group) {
        if (this.userAdmin && this.isUserRealmWritable()) {
            try {
                this.doRetrieveUserList();
                List<User> oldUsers = group.getUsers();
                AssignUsersToGroupWizardIF wizard = this.factory.getAssignUsersToGroupWizard(this.dialog);
                wizard.construct(group, this.userList);
                wizard.invokeWizard();
                GroupWithUsers editedGroup = wizard.getResult();
                if (editedGroup != null) {
                    List<User> newUsers = editedGroup.getUsers();
                    ArrayList<User> addedUsers = new ArrayList<User>();
                    ArrayList<User> removedUsers = new ArrayList<User>();
                    int i = 0;
                    while (i < oldUsers.size()) {
                        if (!newUsers.contains(oldUsers.get(i))) {
                            removedUsers.add(oldUsers.get(i));
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < newUsers.size()) {
                        if (!oldUsers.contains(newUsers.get(i))) {
                            addedUsers.add(newUsers.get(i));
                        }
                        ++i;
                    }
                    editedGroup.setUsers(addedUsers);
                    EOClientRequest request = new EOClientRequest("User", "AddUsersToGroup", editedGroup.getEOGroupUsers());
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    editedGroup.setUsers(removedUsers);
                    request = new EOClientRequest("User", "RemoveUsersFromGroup", editedGroup.getEOGroupUsers());
                    PSCClientServiceFacade.getFacade().sendRequest(this.serverID, request);
                    this.doRetrieveGroupList();
                    group.setUsers(newUsers);
                }
            }
            catch (EXServerException e) {
                PSCClientServiceFacade.getFacade().showException(e, this.serverID);
            }
            catch (ServerNotAvailableException serverNotAvailableException) {
            }
            catch (UnknownServerException unknownServerException) {
            }
            catch (LoginCanceledException loginCanceledException) {}
        } else {
            this.showInsufficentPrivilegesMessage();
        }
    }

    private void doRetrieveGroupList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.groupList.loadGroupsWithUsersAndPrivilegesFromServer(this.serverID);
    }

    private void doRetrievePermissionList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.permissionListModel.loadPermissionsFromServer(this.serverID);
    }

    private void doRetrieveUserList() throws ServerNotAvailableException, EXServerException, LoginCanceledException, UnknownServerException {
        this.userList.loadUsersFromServer(this.serverID);
    }

    private void showInsufficentPrivilegesMessage() {
        PSCClientServiceFacade.getFacade().showInfoMessage(String.valueOf(Messages.getString("CtrlAdminGroups.You_don__t_have_sufficient_permissions_for_that_action_!__2")) + Messages.getString("CtrlAdminGroups.You_must_have_administrator_permissions_in_at_least_one_of_the_currently_connected_servers._3"), this.serverID);
    }
}

