/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.date.RFC1123DateFormatter;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLDecoder;
import de.plans.psc.client.communication.AbstractRequestJob;
import de.plans.psc.client.communication.EXNotLoggedInOrConnectionBroken;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.httputil.HTTPUtil;
import de.plans.psc.client.communication.transmissionprocessor.AlienHTTPResponseException;
import de.plans.psc.client.communication.transmissionprocessor.SunJvmBug6514454Workaround;
import de.plans.psc.shared.message.CompressionType;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServerResponse;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class StepAbstractStandardRequestJob
extends AbstractRequestJob
implements IRequestJob {
    private static final ILogger logger = Logger.getLogger(StepAbstractStandardRequestJob.class);
    protected EOClientRequest request = null;
    protected EOServerResponse response = null;
    protected EXNotLoggedInOrConnectionBroken exNotConnected = null;
    protected IOException ioException = null;
    protected EXDecoderException exDecoderException = null;

    protected StepAbstractStandardRequestJob() {
    }

    private void rethrowExceptions() throws EXNotLoggedInOrConnectionBroken, IOException, EXDecoderException {
        if (this.exNotConnected != null) {
            throw this.exNotConnected;
        }
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.exDecoderException != null) {
            throw this.exDecoderException;
        }
    }

    @Override
    public EOServerResponse getServerResponse() throws EXNotLoggedInOrConnectionBroken, IOException, EXDecoderException {
        this.waitUntilRequestIsProcessed(0L);
        this.rethrowExceptions();
        return this.response;
    }

    @Override
    public EOClientRequest getRequest() {
        return this.request;
    }

    public Long extractLatestNotificationPacketSerial() {
        Long result = null;
        if (this.response != null && this.response.getLatestNotificationPacketSerial() != null) {
            result = this.response.getLatestNotificationPacketSerial().getValue();
        }
        return result;
    }

    public boolean isExNeedReloginOccured() {
        return this.response.isExceptionMsg() && "ServerLoginException".equals(this.response.getException().getGroup()) && "NeedReloginException".equals(this.response.getException().getId());
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static EOServerResponse sendRequestAndParseResponse(URL serverURL, EOClientRequest request, XMLDecoder xmlDecoder, PSCAbstractMessageDataFactory messageFactory) throws IOException, EXDecoderException {
        block68: {
            block65: {
                block67: {
                    block66: {
                        block64: {
                            preferredCompressionTypes = new CompressionType[]{CompressionType.NO_COMPRESSION};
                            requestCompressionType = CompressionType.NO_COMPRESSION;
                            filePairForRequestResponseCycleLogging = null;
                            if (StepAbstractStandardRequestJob.logger.isTraceEnabled() && StepAbstractStandardRequestJob.logger.isDebugEnabled(171) && (connectionTraceLogInfo = ConnectionTraceLogInfo.getTraceLogInfoForURL(serverURL)) != null) {
                                filePairForRequestResponseCycleLogging = connectionTraceLogInfo.getFilePairForRequestResponseCycleLogging();
                                StepAbstractStandardRequestJob.logger.trace("ConnectionTraceLogging: Sending request to server: " + serverURL + " using tracefiles #" + filePairForRequestResponseCycleLogging.getNumberString());
                            }
                            try {
                                httpURLConnection = (HttpURLConnection)serverURL.openConnection();
                            }
                            catch (ClassCastException e) {
                                msg = "Unsupported communication protocol \"" + serverURL.getProtocol() + "\". Supported Protocols are \"http\" and \"https\"";
                                ioex = new IOException(msg);
                                ioex.initCause(e);
                                throw ioex;
                            }
                            httpURLConnection.setRequestProperty("CONTENT-TYPE", "psc-client-request");
                            httpURLConnection.setRequestProperty("CompressionType", requestCompressionType.getName());
                            httpURLConnection.setInstanceFollowRedirects(false);
                            encodedCompressionTypes = CompressionType.encodePreferredCompressionTypeListAsHttpHeaderValues(preferredCompressionTypes);
                            for (String encodedCompressionType : encodedCompressionTypes) {
                                httpURLConnection.addRequestProperty("PreferredCompressionTypes", encodedCompressionType);
                            }
                            httpURLConnection.setDoInput(true);
                            httpURLConnection.setDoOutput(true);
                            if (filePairForRequestResponseCycleLogging != null) {
                                msg = "The Request includes the following Properties:\n";
                                for (Map.Entry requestPropertyEntry : httpURLConnection.getRequestProperties().entrySet()) {
                                    msg = String.valueOf(msg) + "    Name: " + (requestPropertyEntry.getKey() == null ? " <null> " : (String)requestPropertyEntry.getKey()) + "\n";
                                    values = (List)requestPropertyEntry.getValue();
                                    if (values == null) continue;
                                    for (String value : values) {
                                        msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                                    }
                                }
                                StepAbstractStandardRequestJob.logger.trace(msg);
                            }
                            SunJvmBug6514454Workaround.fixHttpsClientSetup(serverURL);
                            try {
                                requestFile = null;
                                if (filePairForRequestResponseCycleLogging != null) {
                                    requestFile = filePairForRequestResponseCycleLogging.getRequestLogFile(requestCompressionType);
                                    requestStream = new FileOutputStream(requestFile);
                                } else {
                                    requestStream = httpURLConnection.getOutputStream();
                                }
                                if (!StepAbstractStandardRequestJob.$assertionsDisabled && requestCompressionType != CompressionType.NO_COMPRESSION) {
                                    throw new AssertionError();
                                }
                                try {
                                    request.writeToXMLStream(requestStream, false);
                                }
                                catch (EXEncoderException exee) {
                                    throw exee.toNewIOException("Unable to send/serialize Request");
                                }
                                requestStream.close();
                                if (requestFile == null) break block64;
                                try {
                                    DataCopyHelper.copyFile(requestFile, httpURLConnection.getOutputStream(), true);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    throw e.toIOException();
                                }
                            }
                            catch (IllegalArgumentException e) {
                                wrappedIllegalArgumentException = new IOException("Wrapped IllegalArgumentException: " + e.getLocalizedMessage());
                                wrappedIllegalArgumentException.setStackTrace(e.getStackTrace());
                                throw wrappedIllegalArgumentException;
                            }
                        }
                        SunJvmBug6514454Workaround.fixHttpsClientSetup(serverURL);
                        connectIOEx = null;
                        try {
                            try {
                                httpURLConnection.connect();
                                break block65;
                            }
                            catch (IOException ioex) {
                                connectIOEx = ioex;
                                responseCode = httpURLConnection.getResponseCode();
                                if (responseCode == 200 && filePairForRequestResponseCycleLogging == null) break block66;
                                msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                                msg = String.valueOf(msg) + "Response Headers:\n";
                                ** for (headerField : httpURLConnection.getHeaderFields().entrySet())
                            }
                        }
                        catch (Throwable e) {
                            responseCode = httpURLConnection.getResponseCode();
                            if (responseCode == 200 && filePairForRequestResponseCycleLogging == null) break block67;
                            msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                            msg = String.valueOf(msg) + "Response Headers:\n";
                            ** for (headerField : httpURLConnection.getHeaderFields().entrySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                            values = headerField.getValue();
                            if (values == null) continue;
                            for (String value : values) {
                                msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                            }
                            continue;
                        }
lbl83:
                        // 1 sources

                        StepAbstractStandardRequestJob.logger.debug(msg);
                        connectionErrorStream = httpURLConnection.getErrorStream();
                        if (connectionErrorStream != null) {
                            if (filePairForRequestResponseCycleLogging != null) {
                                errorLogFile = filePairForRequestResponseCycleLogging.getErrorLogFile(".html");
                                try {
                                    DataCopyHelper.copyFile(connectionErrorStream, errorLogFile);
                                }
                                catch (JvmExternalResourceInteractionException e) {
                                    StepAbstractStandardRequestJob.logger.debug("Problem while copying error Stream into log file ", e);
                                }
                                errorStream = new FileInputStream(errorLogFile);
                            } else {
                                errorStream = connectionErrorStream;
                            }
                            try {
                                byteArrayOutputStream = new ByteArrayOutputStream();
                                DataCopyHelper.copyFile((InputStream)errorStream, byteArrayOutputStream);
                                responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                                StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: " + responseContentAsString);
                            }
                            catch (JvmExternalResourceInteractionException e) {
                                StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", e);
                            }
                        } else {
                            StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: <empty error stream>");
                        }
                    }
                    if (connectIOEx != null) {
                        throw connectIOEx;
                    }
                    break block68;
lbl-1000:
                    // 1 sources

                    {
                        msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                        values = headerField.getValue();
                        if (values == null) continue;
                        for (String value : values) {
                            msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                        }
                        continue;
                    }
lbl123:
                    // 1 sources

                    StepAbstractStandardRequestJob.logger.debug(msg);
                    connectionErrorStream = httpURLConnection.getErrorStream();
                    if (connectionErrorStream != null) {
                        if (filePairForRequestResponseCycleLogging != null) {
                            errorLogFile = filePairForRequestResponseCycleLogging.getErrorLogFile(".html");
                            try {
                                DataCopyHelper.copyFile(connectionErrorStream, errorLogFile);
                            }
                            catch (JvmExternalResourceInteractionException e) {
                                StepAbstractStandardRequestJob.logger.debug("Problem while copying error Stream into log file ", e);
                            }
                            errorStream = new FileInputStream(errorLogFile);
                        } else {
                            errorStream = connectionErrorStream;
                        }
                        try {
                            byteArrayOutputStream = new ByteArrayOutputStream();
                            DataCopyHelper.copyFile((InputStream)errorStream, byteArrayOutputStream);
                            responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                            StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: " + responseContentAsString);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", e);
                        }
                    } else {
                        StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: <empty error stream>");
                    }
                }
                if (connectIOEx != null) {
                    throw connectIOEx;
                }
                throw e;
            }
            responseCode = httpURLConnection.getResponseCode();
            if (responseCode != 200 || filePairForRequestResponseCycleLogging != null) {
                msg = "Sending request to server: " + serverURL + " returned the following response: " + "(responseCode=" + responseCode + ", responseMessage=\"" + httpURLConnection.getResponseMessage() + "\")\n";
                msg = String.valueOf(msg) + "Response Headers:\n";
                for (Map.Entry<String, List<String>> headerField : httpURLConnection.getHeaderFields().entrySet()) {
                    msg = String.valueOf(msg) + "    Name: " + (headerField.getKey() == null ? " <null> " : headerField.getKey()) + "\n";
                    values = headerField.getValue();
                    if (values == null) continue;
                    for (String value : values) {
                        msg = String.valueOf(msg) + "        Value: " + (value == null ? " <null> " : value) + "\n";
                    }
                }
                StepAbstractStandardRequestJob.logger.debug(msg);
                connectionErrorStream = httpURLConnection.getErrorStream();
                if (connectionErrorStream != null) {
                    if (filePairForRequestResponseCycleLogging != null) {
                        errorLogFile = filePairForRequestResponseCycleLogging.getErrorLogFile(".html");
                        try {
                            DataCopyHelper.copyFile(connectionErrorStream, errorLogFile);
                        }
                        catch (JvmExternalResourceInteractionException e) {
                            StepAbstractStandardRequestJob.logger.debug("Problem while copying error Stream into log file ", e);
                        }
                        errorStream = new FileInputStream(errorLogFile);
                    } else {
                        errorStream = connectionErrorStream;
                    }
                    try {
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        DataCopyHelper.copyFile((InputStream)errorStream, byteArrayOutputStream);
                        responseContentAsString = HTTPUtil.convertResponseContentToString(byteArrayOutputStream.toByteArray(), httpURLConnection.getContentType());
                        StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: " + responseContentAsString);
                    }
                    catch (JvmExternalResourceInteractionException e) {
                        StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: Unable to convert Error sream Contents to String", e);
                    }
                } else {
                    StepAbstractStandardRequestJob.logger.debug("Returned ErrorStream contents: <empty error stream>");
                }
            }
            if (connectIOEx != null) {
                throw connectIOEx;
            }
        }
        if ((responseCompressionName = httpURLConnection.getHeaderField("CompressionType")) == null) {
            responseCompressionType = CompressionType.NO_COMPRESSION;
            if (filePairForRequestResponseCycleLogging != null) {
                StepAbstractStandardRequestJob.logger.trace("no compression type specified in response - assuming " + responseCompressionType.getName());
            }
        } else {
            responseCompressionType = CompressionType.getCompressionTypeByName(responseCompressionName);
            if (responseCompressionType == null) {
                throw new IOException("Unsupported Compression Type \"" + responseCompressionName + "\". Unable to decode server Response.");
            }
        }
        if (!StepAbstractStandardRequestJob.$assertionsDisabled && CompressionType.NO_COMPRESSION != responseCompressionType) {
            throw new AssertionError();
        }
        connectionInputStream = httpURLConnection.getInputStream();
        if (filePairForRequestResponseCycleLogging != null) {
            responseFile = filePairForRequestResponseCycleLogging.getResponseLogFile(responseCompressionType);
            try {
                DataCopyHelper.copyFile(connectionInputStream, responseFile);
            }
            catch (JvmExternalResourceInteractionException e) {
                throw e.toIOException();
            }
            responseStream = new FileInputStream(responseFile);
        } else {
            responseStream = connectionInputStream;
        }
        isCockpitserverResponse = httpURLConnection.getHeaderField("CompressionType") != null ? true : ((contentType = httpURLConnection.getContentType()) == null ? true : (contentType.indexOf("psc") != -1 ? true : contentType.indexOf("cockpit") != -1));
        if (!isCockpitserverResponse) {
            responseContentBytes = HTTPUtil.copyResponseStreamToByteArrayOutputStream(responseStream);
            throw AlienHTTPResponseException.createInstance(httpURLConnection, responseContentBytes);
        }
        return (EOServerResponse)xmlDecoder.decodeXML(responseStream, (IEncodableObjectFactory)messageFactory, true);
    }

    private static class ConnectionTraceLogFilePair {
        private final File connectionTraceLogDirectory;
        private final String numberString;

        public ConnectionTraceLogFilePair(File p_connectionTraceLogDirectory, long cycleNumber) {
            this.connectionTraceLogDirectory = p_connectionTraceLogDirectory;
            String ZEROS = "0000";
            String s = Long.toString(cycleNumber);
            if (s.length() < "0000".length()) {
                s = String.valueOf("0000".substring(s.length())) + s;
            }
            this.numberString = s;
        }

        public String getNumberString() {
            return this.numberString;
        }

        public File getRequestLogFile(CompressionType compressionType) {
            return new File(this.connectionTraceLogDirectory, String.valueOf(this.numberString) + "request" + compressionType.getTraceLogFileExtension());
        }

        public File getResponseLogFile(CompressionType compressionType) {
            return new File(this.connectionTraceLogDirectory, String.valueOf(this.numberString) + "response" + compressionType.getTraceLogFileExtension());
        }

        public File getErrorLogFile(String errorLogFileExtension) {
            return new File(this.connectionTraceLogDirectory, String.valueOf(this.numberString) + "error" + errorLogFileExtension);
        }
    }

    private static class ConnectionTraceLogInfo {
        private static final char TRACE_RECORDING_INITIAL = '?';
        private static final char TRACE_RECORDING_DISABLED = 'D';
        private static final char TRACE_RECORDING_ENABLED = 'E';
        private static final long MinRootDirCheckInterval = 30000L;
        private static char traceRecordingEnabledState = (char)63;
        private static File connectiontraceLogRootDir = null;
        private static long lastLogRootDirCheckTime = -1L;
        private static final Map<String, ConnectionTraceLogInfo> connectionTraceLogLocations = new HashMap<String, ConnectionTraceLogInfo>();
        public static final long REQUEST_RESPONSE_CYCLENUMBER_FLOOR_VALUE = 0L;
        public final File connectionTraceLogDirectory;
        public long requestResponseCycleNumber;

        private static synchronized boolean isTraceRecordingEnabled() {
            if (traceRecordingEnabledState != 'E' && lastLogRootDirCheckTime + 30000L < System.currentTimeMillis()) {
                traceRecordingEnabledState = (char)68;
                String userHomeDirName = System.getProperty("user.home");
                File userHomeDir = new File(userHomeDirName);
                connectiontraceLogRootDir = new File(userHomeDir, "ConnectionTraceDirectory");
                if (connectiontraceLogRootDir.isDirectory() && connectiontraceLogRootDir.canWrite() && connectiontraceLogRootDir.list().length == 0) {
                    traceRecordingEnabledState = (char)69;
                    logger.debug("ConnectionTraceLogging is enabled. Trace logs will be stored here: " + connectiontraceLogRootDir.getPath());
                } else {
                    if (lastLogRootDirCheckTime < 0L) {
                        logger.debug("ConnectionTraceLogging could not be enabled because the directory " + connectiontraceLogRootDir.getPath() + " either does not exist, is not empty or is not writeable. " + "Please ensure that the directory does exist, is empty and writeable and wait for at least " + 30000L + " milliseconds.");
                    }
                    lastLogRootDirCheckTime = System.currentTimeMillis();
                }
            }
            return 'E' == traceRecordingEnabledState;
        }

        public static synchronized ConnectionTraceLogInfo getTraceLogInfoForURL(URL url) {
            ConnectionTraceLogInfo result;
            block6: {
                try {
                    if (ConnectionTraceLogInfo.isTraceRecordingEnabled()) {
                        String urlString = url.toExternalForm();
                        int colonIndex = urlString.indexOf(59);
                        String key = colonIndex > 0 ? urlString.substring(0, colonIndex) : urlString;
                        result = connectionTraceLogLocations.get(key);
                        if (result != null) break block6;
                        long currentTimeMillis = System.currentTimeMillis();
                        File connectiontraceLogDir = new File(connectiontraceLogRootDir, Long.toString(currentTimeMillis));
                        File serverinfoFile = new File(connectiontraceLogDir, "serverinfo.txt");
                        String dateString = RFC1123DateFormatter.getRFC1123String(new Date(currentTimeMillis));
                        FileHelper.ensureDirectoryExistance(connectiontraceLogDir);
                        try (FileWriter w = new FileWriter(serverinfoFile);){
                            w.write("key:  " + key + "\n");
                            w.write("url:  " + urlString + "\n");
                            w.write("date: " + dateString);
                        }
                        logger.debug("Enabled ConnectionTraceLogging for server " + url.toExternalForm() + " at " + dateString + ". Storing client server communication data trace in directory " + connectiontraceLogDir.toString());
                        result = new ConnectionTraceLogInfo(connectiontraceLogDir);
                        connectionTraceLogLocations.put(key, result);
                        break block6;
                    }
                    result = null;
                }
                catch (Throwable th) {
                    logger.error("ConnectionTraceLogging: Problem while checking if trace logging is enabled - assume disabled.");
                    result = null;
                }
            }
            return result;
        }

        public ConnectionTraceLogInfo(File connectionTraceLogDirectory) {
            this.connectionTraceLogDirectory = connectionTraceLogDirectory;
            this.requestResponseCycleNumber = 0L;
        }

        public synchronized ConnectionTraceLogFilePair getFilePairForRequestResponseCycleLogging() {
            ++this.requestResponseCycleNumber;
            return new ConnectionTraceLogFilePair(this.connectionTraceLogDirectory, this.requestResponseCycleNumber);
        }
    }
}

