/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeJob;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeProcessor;
import de.plans.psc.shared.message.RequestStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SegmentExchangeProcessorPool {
    private static final ILogger LOGGER = Logger.getLogger(SegmentExchangeProcessorPool.class);
    private static long maxSegmentExchangeProcessorID = 0L;
    private static final long ProcessorLimit = 10L;
    private static final long ClientPatience = 4000L;
    private final String serverName;
    private final HashMap<SegmentExchangeProcessor, SegmentExchangeJob> processorOccupation;
    private final RequestLimiter requestLimiter;
    private boolean isDisposed;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus;

    public SegmentExchangeProcessorPool(String serverName) {
        this.serverName = serverName;
        this.processorOccupation = new HashMap();
        this.requestLimiter = new RequestLimiter();
        this.isDisposed = false;
    }

    /*
     * Unable to fully structure code
     */
    public void exchangeSegment(SegmentExchangeJob segmentExchangeJob) throws ExSegmentExchangeImpossible {
        block10: {
            this.requestLimiter.doDelay();
            segmentExchangeProcessor = this.allocateFreeProcessor(segmentExchangeJob);
            if (!SegmentExchangeProcessorPool.$assertionsDisabled && segmentExchangeProcessor == null) {
                throw new AssertionError();
            }
            startTime = System.currentTimeMillis();
            endOfTetherTime = startTime + 4000L;
            segmentExchangeJobStatus = segmentExchangeJob.getSegmentExchangeJobStatus();
            while (segmentExchangeJobStatus != SegmentExchangeJob.SegmentExchangeJobStatus.Completed && segmentExchangeJobStatus != SegmentExchangeJob.SegmentExchangeJobStatus.FailedWithError && (remainingWaitTime = endOfTetherTime - (currentTime = System.currentTimeMillis())) > 0L) {
                segmentExchangeJobStatus = segmentExchangeJob.waitForStatusChange(segmentExchangeJobStatus, remainingWaitTime);
            }
            if (segmentExchangeJobStatus != SegmentExchangeJob.SegmentExchangeJobStatus.Virgin) ** GOTO lbl22
            if (!SegmentExchangeProcessorPool.$assertionsDisabled) {
                throw new AssertionError();
            }
            SegmentExchangeProcessorPool.LOGGER.warn("Segment Exchange Processor " + segmentExchangeProcessor.toString() + " did not even manage to start the segment exchange process within " + 4000L + "ms. Assuming Segment Exchange Processor thread died somehow.");
            this.killFaultyProcessor(segmentExchangeProcessor);
            break block10;
lbl-1000:
            // 1 sources

            {
                oldSegmentExchangeJobStatus = segmentExchangeJobStatus;
                oldScore = segmentExchangeJob.getProgressScore();
                if (oldSegmentExchangeJobStatus != (segmentExchangeJobStatus = segmentExchangeJob.waitForStatusChange(segmentExchangeJobStatus, 4000L)) || oldScore != (newScore = segmentExchangeJob.getProgressScore())) continue;
                SegmentExchangeProcessorPool.LOGGER.debug("Segment exchange did not make noteworthy progress for 4000 milliseconds. Giving up.");
                break;
lbl22:
                // 2 sources

                ** while (segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.SendingRequest || segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.ServerSegmentHeaderReceived)
            }
        }
        if (segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.ServerSegmentHeaderReceived || segmentExchangeJobStatus == SegmentExchangeJob.SegmentExchangeJobStatus.Completed) {
            switch (SegmentExchangeProcessorPool.$SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus()[segmentExchangeJob.getServerSegmentHeader().getRequestStatus().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    throw new ExSegmentExchangeImpossible("The server reported this request as being \"FailedDueToInternalServerError\".");
                }
                case 6: {
                    throw new ExSegmentExchangeImpossible("The server reported this request as being \"Historic\" and is hence no longer able to provide more information about it.");
                }
            }
        }
        this.requestLimiter.updateLimitInfoAfterSegmentExchangeAttempt(segmentExchangeJob);
    }

    private synchronized SegmentExchangeProcessor allocateFreeProcessor(SegmentExchangeJob segmentExchangeJob) throws ExSegmentExchangeImpossible {
        if (this.isDisposed) {
            throw new ExSegmentExchangeImpossible("SegmentExchangeProcessor Pool already disposed.");
        }
        SegmentExchangeProcessor allocatedProcessor = null;
        ArrayList<SegmentExchangeProcessor> freeProcessors = new ArrayList<SegmentExchangeProcessor>(this.processorOccupation.size());
        for (Map.Entry<SegmentExchangeProcessor, SegmentExchangeJob> entry : this.processorOccupation.entrySet()) {
            SegmentExchangeProcessor processor = entry.getKey();
            SegmentExchangeJob exchangeJob = entry.getValue();
            if (exchangeJob != null) {
                switch (exchangeJob.getSegmentExchangeJobStatus()) {
                    case Virgin: 
                    case SendingRequest: 
                    case ServerSegmentHeaderReceived: {
                        break;
                    }
                    case Completed: 
                    case FailedWithError: {
                        freeProcessors.add(processor);
                    }
                }
                continue;
            }
            freeProcessors.add(processor);
        }
        int i = 0;
        while (i < freeProcessors.size()) {
            SegmentExchangeProcessor processor = (SegmentExchangeProcessor)freeProcessors.get(i);
            if (i == 0) {
                allocatedProcessor = processor;
            } else {
                processor.stopProcessor();
            }
            this.processorOccupation.remove(processor);
            ++i;
        }
        if (allocatedProcessor == null) {
            if ((long)this.processorOccupation.size() < 10L) {
                allocatedProcessor = this.createNewSegmentExchangeProcessor();
            } else {
                throw new ExSegmentExchangeImpossible("SegmentExchangeProcessor Limit exceeded 10");
            }
        }
        this.processorOccupation.put(allocatedProcessor, segmentExchangeJob);
        allocatedProcessor.exchangeSegment(segmentExchangeJob);
        return allocatedProcessor;
    }

    private synchronized void killFaultyProcessor(SegmentExchangeProcessor processor) {
        this.processorOccupation.remove(processor);
        processor.stopProcessor();
    }

    public synchronized void dispose() {
        this.isDisposed = true;
        for (SegmentExchangeProcessor processor : this.processorOccupation.keySet()) {
            processor.stopProcessor();
        }
        this.processorOccupation.clear();
    }

    private SegmentExchangeProcessor createNewSegmentExchangeProcessor() {
        SegmentExchangeProcessor segmentExchangeProcessor = new SegmentExchangeProcessor(SegmentExchangeProcessorPool.getNextFreeSegmentExchangeProcessorID(), this.serverName);
        return segmentExchangeProcessor;
    }

    private static synchronized long getNextFreeSegmentExchangeProcessorID() {
        return ++maxSegmentExchangeProcessorID;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus() {
        if ($SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus != null) {
            return $SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus;
        }
        int[] nArray = new int[RequestStatus.values().length];
        try {
            nArray[RequestStatus.FailedDueToInternalServerError.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RequestStatus.Historic.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RequestStatus.InProgress.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RequestStatus.ReceivingRequestData.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RequestStatus.ResponseDataAvailable.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[RequestStatus.WaitingForProcessor.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$de$plans$psc$shared$message$RequestStatus = nArray;
        return nArray;
    }

    public static class ExPrematureEndOfSegmentExchange
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ExPrematureEndOfSegmentExchange() {
        }

        public ExPrematureEndOfSegmentExchange(String message) {
            super(message);
        }
    }

    public static class ExSegmentExchangeImpossible
    extends ExPrematureEndOfSegmentExchange {
        private static final long serialVersionUID = 1L;

        public ExSegmentExchangeImpossible() {
        }

        public ExSegmentExchangeImpossible(String message) {
            super(message);
        }
    }

    private class RequestLimiter {
        private long failedRequestsSinceLastSuccessfulRequest = 0L;
        private long lastRequestTime;

        public synchronized void updateLimitInfoAfterSegmentExchangeAttempt(SegmentExchangeJob segmentExchangeJob) {
            SegmentExchangeJob.SegmentExchangeJobStatus segmentExchangeJobStatus = segmentExchangeJob.getSegmentExchangeJobStatus();
            switch (segmentExchangeJobStatus) {
                case SendingRequest: {
                    break;
                }
                case ServerSegmentHeaderReceived: {
                    break;
                }
                case Completed: {
                    this.failedRequestsSinceLastSuccessfulRequest = 0L;
                    break;
                }
                case Virgin: {
                    assert (false);
                }
                case FailedWithError: {
                    if (this.failedRequestsSinceLastSuccessfulRequest == 0L) {
                        this.failedRequestsSinceLastSuccessfulRequest = 1L;
                        break;
                    }
                    ++this.failedRequestsSinceLastSuccessfulRequest;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doDelay() {
            long minRequestInterval = this.failedRequestsSinceLastSuccessfulRequest <= 1L ? 0L : (this.failedRequestsSinceLastSuccessfulRequest <= 10L ? 1000L : 10000L);
            assert (this.failedRequestsSinceLastSuccessfulRequest > 1L || minRequestInterval == 0L) : "lastRequestTime is not initialized correctly if this assertion fails.";
            if (this.failedRequestsSinceLastSuccessfulRequest > 0L) {
                long currentTime = System.currentTimeMillis();
                if (minRequestInterval > 0L) {
                    long waitTime = this.lastRequestTime + minRequestInterval - currentTime;
                    if (waitTime > 0L) {
                        try {
                            Object object;
                            Object object2 = object = new Object();
                            synchronized (object2) {
                                object.wait(waitTime);
                            }
                        }
                        catch (InterruptedException e) {
                            LOGGER.error("Unexpected InterruptedException:", e);
                        }
                        this.lastRequestTime += minRequestInterval;
                    } else {
                        this.lastRequestTime = currentTime;
                    }
                } else {
                    this.lastRequestTime = currentTime;
                }
            }
        }
    }
}

