/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication.transmissionprocessor;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.transmissionprocessor.SegmentExchangeJob;
import de.plans.psc.client.communication.transmissionprocessor.SunJvmBug6514454Workaround;
import de.plans.psc.shared.message.AbstractStreamDataBuffer;
import de.plans.psc.shared.message.FragmentedStreamDataBuffer;
import de.plans.psc.shared.message.SegmentHeaderEncoder;
import de.plans.psc.shared.message.ServerSegmentHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.LinkedList;

public class SegmentExchangeProcessor
implements Runnable {
    private static final ILogger LOGGER = Logger.getLogger(SegmentExchangeProcessor.class);
    private static final String THREAD_NAME = "SegmentExchangeProcessor";
    private final LinkedList<ISegmentExchangeProcessorStep> processorStepQueue;
    private boolean mainLoopStopInitiated = false;
    private boolean mainLoopStopped = false;
    private final ISegmentExchangeProcessorStep stepNOP = new ISegmentExchangeProcessorStep(){

        @Override
        public void executeStep() {
        }
    };
    private final ISegmentExchangeProcessorStep stepStopProcessor = new ISegmentExchangeProcessorStep(){

        @Override
        public void executeStep() {
            SegmentExchangeProcessor.this.mainLoopStopped = true;
        }
    };

    public SegmentExchangeProcessor(long segmentExchangeProcessorID, String serverName) {
        this.processorStepQueue = new LinkedList();
        Thread t = new Thread((Runnable)this, "SegmentExchangeProcessor - " + segmentExchangeProcessorID + " -- " + serverName);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.mainLoopStopped) {
            ISegmentExchangeProcessorStep nextStep = null;
            SegmentExchangeProcessor segmentExchangeProcessor = this;
            synchronized (segmentExchangeProcessor) {
                if (!this.processorStepQueue.isEmpty()) {
                    nextStep = this.processorStepQueue.removeFirst();
                } else {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    nextStep = this.stepNOP;
                }
            }
            try {
                nextStep.executeStep();
            }
            catch (Throwable throwable) {
                LOGGER.error("SegmentExchangeProcessor: An Exception was encountered within the " + this.getClass().getSimpleName() + " main-loop.", throwable);
            }
        }
    }

    public synchronized void stopProcessor() {
        if (!this.mainLoopStopInitiated) {
            this.mainLoopStopInitiated = true;
            this.processorStepQueue.clear();
            this.processorStepQueue.add(this.stepStopProcessor);
            this.notifyAll();
        }
    }

    private synchronized void queueNewProcessorStep(ISegmentExchangeProcessorStep newStep) {
        if (this.mainLoopStopInitiated) {
            LOGGER.warn("Attempt to enque new Step after the processor has been taken out of service.", new Exception());
        } else {
            this.processorStepQueue.add(newStep);
            assert (this.processorStepQueue.size() < 2);
            this.notifyAll();
        }
    }

    public void exchangeSegment(SegmentExchangeJob segmentExchangeJob) {
        ExchangeSegmentStep step = new ExchangeSegmentStep(segmentExchangeJob);
        this.queueNewProcessorStep(step);
    }

    private static void appendSegmentDataToBuffer(FragmentedStreamDataBuffer response, ServerSegmentHeader serverSegmentHeader, InputStream serverSegmentStream, AbstractStreamDataBuffer.IBufferTransferProgressWatchdog watchdog) throws IOException {
        if (serverSegmentHeader.getResponseBytesTotalLength() >= 0L) {
            response.setTotalStreamLength(serverSegmentHeader.getResponseBytesTotalLength());
        } else assert (serverSegmentHeader.getResponseBytesTotalLength() == -1L);
        response.append(serverSegmentHeader.getResponseBytesStartIndex(), serverSegmentHeader.getResponseBytesSegmentLength(), serverSegmentStream, watchdog);
    }

    private class ExchangeSegmentStep
    implements ISegmentExchangeProcessorStep {
        private final SegmentExchangeJob segmentExchangeJob;

        public ExchangeSegmentStep(SegmentExchangeJob segmentExchangeJob) {
            this.segmentExchangeJob = segmentExchangeJob;
        }

        @Override
        public void executeStep() {
            try {
                HttpURLConnection httpURLConnection;
                this.segmentExchangeJob.updateSegmentExchangeJobStatus(SegmentExchangeJob.SegmentExchangeJobStatus.SendingRequest);
                try {
                    httpURLConnection = (HttpURLConnection)this.segmentExchangeJob.getServerURL().openConnection();
                }
                catch (ClassCastException e) {
                    String msg = "Unsupported communication protocol \"" + this.segmentExchangeJob.getServerURL().getProtocol() + "\". Supported Protocols are \"http\" and \"https\"";
                    IOException ioex = new IOException(msg);
                    ioex.initCause(e);
                    throw ioex;
                }
                httpURLConnection.setRequestProperty("CONTENT-TYPE", "application/psc-client-segment");
                httpURLConnection.setInstanceFollowRedirects(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.setDoOutput(true);
                SunJvmBug6514454Workaround.fixHttpsClientSetup(this.segmentExchangeJob.getServerURL());
                OutputStream requestStream = httpURLConnection.getOutputStream();
                this.segmentExchangeJob.getClientSegmentHeader().serializeIntoStream(requestStream);
                if (this.segmentExchangeJob.getClientSegmentHeader().getRequestBytesSegmentLength() > 0L) {
                    this.segmentExchangeJob.getRequestBuffer().copyToStream(requestStream, this.segmentExchangeJob.getClientSegmentHeader().getRequestBytesStartIndex(), this.segmentExchangeJob.getClientSegmentHeader().getRequestBytesSegmentLength(), new AbstractStreamDataBuffer.IBufferTransferProgressWatchdog(){

                        @Override
                        public void noteTransferActivity(long sizeOfTransferredChunk) {
                            ExchangeSegmentStep.this.segmentExchangeJob.incrementProgressScore(sizeOfTransferredChunk);
                        }
                    });
                }
                requestStream.close();
                SunJvmBug6514454Workaround.fixHttpsClientSetup(this.segmentExchangeJob.getServerURL());
                httpURLConnection.connect();
                InputStream serverSegmentStream = httpURLConnection.getInputStream();
                ServerSegmentHeader serverSegmentHeader = ServerSegmentHeader.parseStreamEncodedHeader(serverSegmentStream);
                this.segmentExchangeJob.updateSegmentExchangeJobStatus(serverSegmentHeader);
                assert (serverSegmentHeader.getRequestID().equals(this.segmentExchangeJob.getClientSegmentHeader().getRequestID()));
                SegmentExchangeProcessor.appendSegmentDataToBuffer(this.segmentExchangeJob.getResponse(), serverSegmentHeader, serverSegmentStream, new AbstractStreamDataBuffer.IBufferTransferProgressWatchdog(){

                    @Override
                    public void noteTransferActivity(long sizeOfTransferredChunk) {
                        ExchangeSegmentStep.this.segmentExchangeJob.incrementProgressScore(sizeOfTransferredChunk);
                    }
                });
                this.segmentExchangeJob.updateSegmentExchangeJobStatus(SegmentExchangeJob.SegmentExchangeJobStatus.Completed);
            }
            catch (IOException e) {
                this.segmentExchangeJob.markAsFailed(e);
            }
            catch (SegmentHeaderEncoder.ExInvalidSegmentData e) {
                this.segmentExchangeJob.markAsFailed(e);
            }
        }
    }

    private static interface ISegmentExchangeProcessorStep {
        public void executeStep();
    }
}

