/*
 * Decompiled with CFR 0.152.
 */
package de.plans.psc.client.communication;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.PSCApplicationIdentifier;
import de.plans.psc.client.PSCClientLicenseInfo;
import de.plans.psc.client.communication.EXNotLoggedInOrConnectionBroken;
import de.plans.psc.client.communication.IDataTransferRequestJob;
import de.plans.psc.client.communication.IRequestJob;
import de.plans.psc.client.communication.ISnoopRequestJob;
import de.plans.psc.client.communication.Messages;
import de.plans.psc.client.communication.PSCAuthenticator;
import de.plans.psc.client.communication.RequestForwarder;
import de.plans.psc.client.communication.SSLCommunicationException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.transmissionprocessor.AlienHTTPResponseException;
import de.plans.psc.client.communication.transmissionprocessor.RequestTransmissionAndUpdateEnquiryProcessor;
import de.plans.psc.shared.message.EOClientRequest;
import de.plans.psc.shared.message.EOServer;
import de.plans.psc.shared.message.PSCAbstractMessageDataFactory;
import java.io.File;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class HttpServerConnection
extends ServerConnection {
    private static final ILogger logger = Logger.getLogger(HttpServerConnection.class);
    private static String clientLocation;
    RequestTransmissionAndUpdateEnquiryProcessor transmissionProcessor;
    protected RequestForwarder requestForwarder;

    public HttpServerConnection(EOServer server, PSCAbstractMessageDataFactory messageFactory, RequestForwarder requestForwarder) {
        super(server, requestForwarder);
        try {
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            if (i != null) {
                while (i.hasMoreElements()) {
                    NetworkInterface networkInterface = i.nextElement();
                    Enumeration<InetAddress> j = networkInterface.getInetAddresses();
                    while (j.hasMoreElements()) {
                        InetAddress ip = j.nextElement();
                        String hostname = ip.getCanonicalHostName();
                        clientLocation = clientLocation == null ? hostname : String.valueOf(clientLocation) + ", " + hostname;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.requestForwarder = requestForwarder;
        this.transmissionProcessor = new RequestTransmissionAndUpdateEnquiryProcessor(this.getServerName(), this.createServerURLFromURLString(this.getURL()), this.getTimerInterval(), messageFactory, new RequestTransmissionAndUpdateEnquiryProcessor.INotificationEnquiryResponseConsumer(){

            @Override
            public void processNotificationEnquiryResponse(IRequestJob job) {
                HttpServerConnection.this.requestForwarder.processNotificationEnquiryResponse(HttpServerConnection.this, job);
            }
        });
    }

    @Deprecated
    private URL createServerURLFromURLString(String urlString) {
        URL serverURL = null;
        try {
            serverURL = new URL(urlString);
        }
        catch (MalformedURLException e) {
            try {
                serverURL = new URL("http://127.0.0.1/SeeLogFileForMalformedURLException");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            logger.error("Malformed server url: " + urlString, e);
        }
        return serverURL;
    }

    @Override
    protected void startNotificationEnquiry() {
        this.transmissionProcessor.startNotificationEnquiry();
    }

    @Override
    protected void stopNotificationEnquiry() {
        this.transmissionProcessor.stopNotificationEnquiry();
    }

    @Override
    protected synchronized ServerNotAvailableException translateTransmissionException(EOClientRequest request, Exception transmissionException, boolean connectionOK) {
        try {
            if (transmissionException != null) {
                throw transmissionException;
            }
            return null;
        }
        catch (SSLCommunicationException e) {
            logger.error("processJobResponse() - Unable to establish SSL (HTTPS) connection to server" + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            String msg = NLS.bind((String)Messages.getString("HttpServerConnection.ConnectEX_Unable_to_establish_SSL_connection"), (Object)this.getServerName(), (Object)this.getURL());
            return new ServerNotAvailableException(this.getServerID(), request, msg, e);
        }
        catch (AlienHTTPResponseException e) {
            logger.error("processJobResponse() - The server did return a unfamiliar/alien response. Reasons: The server url probably points to some other kind of server or there is some intermediary server like a proxy or a firewall in the communication path. A internal server error or a uncorrect server setup may also lead to this kind of error but this is unlikely." + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            String msg = NLS.bind((String)Messages.getString("HttpServerConnection.ConnectEX_alien_response"), (Object)this.getServerName(), (Object)this.getURL());
            return new ServerNotAvailableException(this.getServerID(), request, msg, e);
        }
        catch (ConnectException e) {
            String msg = connectionOK ? String.valueOf(Messages.getString("HttpServerConnection.Lost_connection_to_server__2")) + this.getServerName() + Messages.getString("HttpServerConnection.._3") : String.valueOf(Messages.getString("HttpServerConnection.Could_not_connect_to_server__4")) + this.getServerName() + " " + Messages.getString("HttpServerConnection.._5");
            logger.error("processJobResponse() - Error when sending request to server " + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            return new ServerNotAvailableException(this.getServerID(), request, msg, e);
        }
        catch (MalformedURLException e) {
            logger.error("processJobResponse() - Invalid server URL for server " + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            return new ServerNotAvailableException(this.getServerID(), request, Messages.getString("HttpServerConnection.Invalid_server_URL._Please_correct_the_server_specification._8"), e);
        }
        catch (UnknownHostException e) {
            logger.error("processJobResponse() - Could not determine IP address of server " + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            return new ServerNotAvailableException(this.getServerID(), request, Messages.getString("HttpServerConnection.Could_not_determine_IP_address_of_server.__nPlease_check_the_server_specification_and_the_name_service_of_your_network._10"), e);
        }
        catch (Exception e) {
            logger.error("processJobResponse() - Exception while sending a request to server " + this.getServerName() + " (url=\"" + this.getURL() + "\").", e);
            String msg = e instanceof EXNotLoggedInOrConnectionBroken ? Messages.getString("HttpServerConnection.Exception.NotLoggedInOrConnBroken") : Messages.getString("HttpServerConnection.Problem_with_server_connection._See_logfile_for_more_details_12");
            return new ServerNotAvailableException(this.getServerID(), request, msg, e);
        }
    }

    @Override
    public void setURL(String s) {
        super.setURL(s);
        this.transmissionProcessor.updateServerURL(this.createServerURLFromURLString(s));
    }

    @Override
    public void setTimerInterval(int interval) {
        this.transmissionProcessor.setNotificationEnquiryInterval(interval);
        super.setTimerInterval(interval);
    }

    @Override
    protected IRequestJob chargeLoginRequest(PSCApplicationIdentifier applicationIdentifier, PSCClientLicenseInfo clientLicenseSetting, PasswordAuthentication passwordAuthentication, PSCAuthenticator.RequestorInfo requestorInfo, String pscUsername, String pscPassword2) {
        return this.transmissionProcessor.chargeLoginRequest(applicationIdentifier, clientLicenseSetting, passwordAuthentication, requestorInfo, pscUsername, pscPassword2);
    }

    @Override
    protected ISnoopRequestJob chargeSnoopRequest() {
        return this.transmissionProcessor.chargeSnoopRequest();
    }

    @Override
    protected IRequestJob chargeRequest(EOClientRequest request) {
        return this.transmissionProcessor.chargeRequest(request);
    }

    public IDataTransferRequestJob chargeFileUploadRequest(List<String> transferIDs, List<File> files) {
        return this.transmissionProcessor.chargeFileUploadRequest(transferIDs, files);
    }

    protected IDataTransferRequestJob chargeFileDownloadRequest(List<String> transferIDs, List<File> files) {
        return this.transmissionProcessor.chargeFileDownloadRequest(transferIDs, files);
    }

    @Override
    protected IRequestJob chargeDisconnectRequest() {
        return this.transmissionProcessor.chargeDisconnectRequest();
    }

    @Override
    public void shutdownAndFreeResources() {
        this.transmissionProcessor.shutdownAndFreeResources();
        this.transmissionProcessor = null;
        this.requestForwarder = null;
    }

    @Override
    public String getClientLocation() {
        return clientLocation;
    }

    @Override
    public String getDirectoryType() {
        String pscDirectoryType = this.getServerInfo().getUserRealmRepositoryType();
        String directoryType = "LDAP".equals(pscDirectoryType) ? "LDAP" : ("PSC-Server".equals(pscDirectoryType) ? "PSC-Server" : ("Single-User".equals(pscDirectoryType) ? "Single-User" : pscDirectoryType));
        return directoryType;
    }

    @Override
    public String getDirectoryNameOrURL() {
        String nameOrURL = "PSC-Server".equals(this.getDirectoryType()) ? this.getURL() : this.getServerInfo().getUserRealmRepositoryNameOrURL();
        return nameOrURL;
    }

    @Override
    public String getDistinguishedName() {
        String distinguishedName = null;
        if ("PSC-Server".equals(this.getDirectoryType())) {
            distinguishedName = this.getUserData().getUser().getDescription();
        }
        if (distinguishedName == null) {
            distinguishedName = this.getUserData().getUser().getUserName();
        }
        return distinguishedName;
    }

    @Override
    public String getLoginID() {
        return this.getUserData().getUser().getUserName();
    }

    @Override
    public String getRealName() {
        return this.getUserData().getUser().getDisplayName();
    }

    @Override
    public String getUserName() {
        if (this.getUserData() != null && this.getUserData().getUser() != null && this.getUserData().getUser().getUserName() != null) {
            return this.getUserData().getUser().getUserName();
        }
        return "";
    }
}

