/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.primitiveTypes;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EOEncodableObjectWithRole;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOInteger
extends EOEncodableObjectWithRole {
    private static final ILogger logger = Logger.getLogger(EOInteger.class);
    private static final String DEFAULT_ROLE = "value";
    public static final String XML_NAME = "frame.datatype.integer";
    private Integer integer;

    public EOInteger(Integer integer) {
        super(XML_NAME);
        this.integer = integer;
        this.setRole(DEFAULT_ROLE);
    }

    public EOInteger(Integer integer, String role) {
        super(XML_NAME);
        this.integer = integer;
        this.setRole(role);
    }

    public EOInteger(int integer, String role) {
        this(new Integer(integer), role);
    }

    public EOInteger(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
    }

    public Integer getInteger() {
        return this.integer;
    }

    @Override
    protected void writeContentToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        this.appendContentToXML(writeContext, this.integer);
    }

    @Override
    protected boolean hasContent() {
        return true;
    }

    @Override
    protected boolean setContentFromXML(String value) {
        if (this.integer == null) {
            try {
                this.integer = Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                logger.error("wrong number format in XML", e);
                this.integer = new Integer(0);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }
}

