/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding.sequential.read;

import com.arcway.lib.codec.EXDecoderException;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;

public class EOElementDispatcher<C extends EncodableObjectBase, E extends EncodableObjectBase>
extends EOEncodableObject {
    private final IEOContainerProcessor<C, E> containerProcessor;
    private final C emptyContainer;

    public EOElementDispatcher(String xmlName, XMLContext xmlContext, C emptyContainer, IEOContainerProcessor<C, E> containerProcessor) {
        super(xmlName, xmlContext);
        assert (emptyContainer != null);
        this.containerProcessor = containerProcessor;
        this.emptyContainer = emptyContainer;
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        ((EncodableObjectBase)this.emptyContainer).setAttribute(name, value);
        return true;
    }

    @Override
    protected void attributesSet() {
        this.containerProcessor.beginContainer(this.emptyContainer);
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        if (newChild instanceof EOElementDispatcher) {
            EOElementDispatcher childElementDispatcher = (EOElementDispatcher)newChild;
            this.containerProcessor.processEO(childElementDispatcher.emptyContainer);
        } else {
            EncodableObjectBase typedChild = newChild;
            this.containerProcessor.processEO(typedChild);
        }
        return true;
    }

    @Override
    public void endElement() throws EXDecoderException {
        super.endElement();
        this.containerProcessor.endContainer();
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        throw new UnsupportedOperationException("This reader does not implement writing functionallity.");
    }

    @Override
    protected boolean hasChildren() {
        throw new UnsupportedOperationException("This reader does not implement writing functionallity.");
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
        throw new UnsupportedOperationException("This reader does not implement writing functionallity.");
    }
}

