/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding.sequential.read;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.sequential.processing.IEOContainerProcessor;
import de.plans.lib.xml.encoding.sequential.read.EOContainerReaderEvent;
import de.plans.lib.xml.encoding.sequential.read.EOContainerReaderEventBeginContainer;
import de.plans.lib.xml.encoding.sequential.read.EOContainerReaderEventEndContainer;
import de.plans.lib.xml.encoding.sequential.read.EOContainerReaderEventProcessEO;
import de.plans.lib.xml.encoding.sequential.read.IEOContainerReaderEventReceiver;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class EOContainerReaderEventChannel
implements IEOContainerProcessor,
IEOContainerReaderEventReceiver {
    private static final ILogger LOGGER = Logger.getLogger(EOContainerReaderEventChannel.class);
    private final BlockingQueue<EOContainerReaderEvent> eventQueue;

    public EOContainerReaderEventChannel(int bufferSize) {
        assert (bufferSize > 0);
        this.eventQueue = new ArrayBlockingQueue<EOContainerReaderEvent>(bufferSize);
    }

    public void beginContainer(EncodableObjectBase emptyContainer) {
        try {
            this.eventQueue.put(new EOContainerReaderEventBeginContainer(emptyContainer));
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected thread interruption.", e);
        }
    }

    @Override
    public void processEO(EncodableObjectBase encodableObject) {
        try {
            this.eventQueue.put(new EOContainerReaderEventProcessEO(encodableObject));
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected thread interruption.", e);
        }
    }

    @Override
    public void endContainer() {
        try {
            this.eventQueue.put(new EOContainerReaderEventEndContainer());
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected thread interruption.", e);
        }
    }

    @Override
    public <C extends EncodableObjectBase, E extends EncodableObjectBase> void processNextEvent(IEOContainerProcessor<C, E> elementProcessor) {
        try {
            EOContainerReaderEvent event = this.eventQueue.take();
            event.processNextEvent(elementProcessor);
        }
        catch (InterruptedException e) {
            LOGGER.error("Unexpected thread interruption.", e);
        }
    }
}

