/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.codec.EXDecoderException;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.lib.stringtools.StringCanonicalizer;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.XMLContext;
import de.plans.lib.xml.encoding.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.Timestamp;
import org.xml.sax.Attributes;

public abstract class EncodableObjectBase {
    private static final ILogger logger = Logger.getLogger(EncodableObjectBase.class);
    public static final boolean ARE_ATTRIBUTES_IN_EXISTING_XML_FILES_BY_DEFAULT_URLENCODED = true;
    static final String XML_INSTRUCTION_TARGET = "com.arcway.eobase";
    static final String XML_INSTRUCTION_ACTIVATE_ATTRIBUTE_VALUE_URLENCODEDING = "urlencoding=\"true\"";
    static final String XML_INSTRUCTION_DEACTIVATE_ATTRIBUTE_VALUE_URLENCODEDING = "urlencoding=\"false\"";
    private static final boolean URLENCODE_ATTRIBUTE_VALUES_IN_NEW_XML_FILES = false;
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static final StringCanonicalizer stringCanonicalizer = new StringCanonicalizer();
    private final String tag;

    public EncodableObjectBase(String tag) {
        this.tag = stringCanonicalizer.getCanonicalString(tag);
    }

    public EncodableObjectBase(String tag, XMLContext xmlContext) {
        this.tag = stringCanonicalizer.getCanonicalString(tag);
    }

    public final String getTag() {
        return this.tag;
    }

    public void endElement() throws EXDecoderException {
    }

    final void setAttributesFromXMLDecoder(Attributes attr, ReadContext readContext) throws EXDecoderException {
        this.setAttributes(attr, readContext.areAttributeValuesURLEncoded());
    }

    private void setAttributes(Attributes attr, boolean performUrlDecoding) throws EXDecoderException {
        int attrLength = attr.getLength();
        int i = 0;
        while (i < attrLength) {
            String name = attr.getLocalName(i);
            if (name == null || name.length() == 0) {
                name = attr.getQName(i);
            }
            name = stringCanonicalizer.getCanonicalString(name);
            String value = attr.getValue(i);
            if (performUrlDecoding) {
                value = EncodableObjectBase.uRLdecode(value);
            }
            value = stringCanonicalizer.getCanonicalString(value);
            this.setAttribute(name, value);
            ++i;
        }
        this.attributesSet();
    }

    protected void attributesSet() {
    }

    private static String uRLdecode(String toDecode) throws EXDecoderException {
        try {
            return URLDecoder.decode(toDecode, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new EXDecoderException("Unable to decode attribute, unsupported encoding", e);
        }
    }

    private static String uRLencode(String toEncode) throws EXEncoderException {
        try {
            return URLEncoder.encode(toEncode, ENCODING_UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new EXEncoderException("Could not encode attribute " + toEncode, e);
        }
    }

    private static void appendStringToXML(WriteContext outp, String text) throws EXEncoderException {
        try {
            outp.write(text);
        }
        catch (IOException e) {
            EncodableObjectBase.extracted(e);
        }
    }

    protected void appendAttrToXMLWithOutURLEncoding(WriteContext outp, String name, String value) throws EXEncoderException {
        EncodableObjectBase.appendAttrToXMLLowLevel(outp, name, value);
    }

    protected void appendAttrToXML(WriteContext outp, String name, String value) throws EXEncoderException {
        if (name != null && value != null) {
            if (value.length() > 0 && outp.areAttributeValuesToBeURLEncoded()) {
                EncodableObjectBase.appendAttrToXMLLowLevel(outp, name, EncodableObjectBase.uRLencode(value));
            } else {
                EncodableObjectBase.appendAttrToXMLLowLevel(outp, name, value);
            }
        }
    }

    private static void appendAttrToXMLLowLevel(WriteContext outp, String name, String value) throws EXEncoderException {
        try {
            if (name != null && value != null) {
                outp.write(" ");
                outp.write(name);
                outp.write("=\"");
                XMLEncoder.appendStringEscapedToXML(outp, value);
                outp.write("\"");
            }
        }
        catch (IOException e) {
            EncodableObjectBase.extracted(e);
        }
    }

    private static void extracted(IOException e) throws EXEncoderException {
        throw new EXEncoderException("Could not write to XML-Stream", e);
    }

    protected void appendAttrToXML(WriteContext outp, String name, int value) throws EXEncoderException {
        this.appendAttrToXML(outp, name, Integer.toString(value));
    }

    protected void appendAttrToXML(WriteContext outp, String name, short value) throws EXEncoderException {
        this.appendAttrToXML(outp, name, Short.toString(value));
    }

    protected void appendAttrToXML(WriteContext outp, String name, long value) throws EXEncoderException {
        this.appendAttrToXML(outp, name, Long.toString(value));
    }

    protected void appendAttrToXML(WriteContext outp, String name, float value) throws EXEncoderException {
        this.appendAttrToXML(outp, name, Float.toString(value));
    }

    protected void appendAttrToXML(WriteContext outp, String name, double value) throws EXEncoderException {
        this.appendAttrToXML(outp, name, Double.toString(value));
    }

    protected void appendAttrToXML(WriteContext outp, String name, Date value) throws EXEncoderException {
        if (name != null && value != null) {
            this.appendAttrToXML(outp, name, value.toString());
        }
    }

    protected void appendAttrToXML(WriteContext outp, String name, Timestamp value) throws EXEncoderException {
        if (name != null && value != null) {
            this.appendAttrToXML(outp, name, value.toString());
        }
    }

    protected void appendAttrToXML(WriteContext outp, String name, Integer value) throws EXEncoderException {
        if (name != null && value != null) {
            this.appendAttrToXML(outp, name, value.toString());
        }
    }

    protected void appendAttrToXML(WriteContext outp, String name, boolean value) throws EXEncoderException {
        if (name != null) {
            this.appendAttrToXML(outp, name, Boolean.toString(value));
        }
    }

    protected void appendContentToXML(WriteContext outp, Boolean value) throws EXEncoderException {
        this.appendContentToXML(outp, value.toString());
    }

    protected void appendContentToXML(WriteContext outp, boolean value) throws EXEncoderException {
        this.appendContentToXML(outp, Boolean.toString(value));
    }

    protected void appendContentToXML(WriteContext outp, String value) throws EXEncoderException {
        try {
            XMLEncoder.appendStringEscapedToXML(outp, value);
        }
        catch (IOException e) {
            EncodableObjectBase.extracted(e);
        }
    }

    protected void appendContentToXML(WriteContext outp, Integer integer) throws EXEncoderException {
        this.appendContentToXML(outp, integer.toString());
    }

    protected void appendContentToXML(WriteContext outp, int integer) throws EXEncoderException {
        this.appendContentToXML(outp, Integer.toString(integer));
    }

    protected void appendContentToXML(WriteContext outp, Long longValue) throws EXEncoderException {
        this.appendContentToXML(outp, longValue.toString());
    }

    protected void appendContentToXML(WriteContext outp, double doubleValue) throws EXEncoderException {
        this.appendContentToXML(outp, Double.toString(doubleValue));
    }

    protected int toInt(String value) {
        return Integer.parseInt(value.trim());
    }

    protected short toShort(String value) {
        return Short.parseShort(value.trim());
    }

    protected long toLong(String value) {
        return Long.parseLong(value.trim());
    }

    protected Integer toInteger(String value) {
        return Integer.valueOf(value.trim());
    }

    protected float toFloat(String value) {
        return Float.parseFloat(value.trim());
    }

    protected double toDouble(String value) {
        return Double.parseDouble(value.trim());
    }

    protected boolean toBoolean(String value) {
        return Boolean.valueOf(value.trim());
    }

    protected Date toDate(String value) {
        return Date.valueOf(value.trim());
    }

    protected Timestamp toTimestamp(String value) {
        return Timestamp.valueOf(value.trim());
    }

    public String toXMLString(boolean formatOutput) throws EXEncoderException {
        return this.toXMLString(ENCODING_UTF_8, formatOutput, true);
    }

    public String toXMLString(boolean formatOutput, boolean withHeader) throws EXEncoderException {
        return this.toXMLString(ENCODING_UTF_8, formatOutput, withHeader);
    }

    public String toXMLString(String encoding, boolean formatOutput, boolean withHeader) throws EXEncoderException {
        StringArrayListWriteContext writeContext = new StringArrayListWriteContext(encoding, false);
        if (withHeader) {
            EncodableObjectBase.writeXMLHeader(writeContext, formatOutput, true);
        }
        this.writeXMLBody((WriteContext)writeContext, formatOutput);
        EncodableObjectBase.closeXMLStream(writeContext);
        return writeContext.getBufferContentsAsString();
    }

    public void writeToFile(File file) throws IOException {
        this.writeToFile(file, ENCODING_UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file, String encoding) throws IOException {
        BufferedOutputStream b_out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            EncodableObjectBase encodableObjectBase = this;
            synchronized (encodableObjectBase) {
                this.writeToXMLStream(b_out, encoding, true);
            }
        }
        catch (Throwable th) {
            IOException ioex = new IOException("Problem while writing XML File. See causing exception for details.");
            ioex.initCause(th);
            throw ioex;
        }
    }

    public final void writeToXMLStream(OutputStream out, boolean formatOutput) throws EXEncoderException {
        this.writeToXMLStream(out, ENCODING_UTF_8, formatOutput);
    }

    public final void writeToXMLStream(OutputStream out, String encoding, boolean formatOutput) throws EXEncoderException {
        RuntimeException rtEx;
        Error err;
        block28: {
            block29: {
                err = null;
                rtEx = null;
                try {
                    WriteContext writeContext = EncodableObjectBase.openXMLStream(out, encoding, formatOutput);
                    this.writeXMLBody(writeContext, formatOutput);
                    EncodableObjectBase.closeXMLStream(writeContext);
                }
                catch (Error e) {
                    err = e;
                    if (rtEx != null || err != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable th) {
                            logger.error("Problem while closing File Stream after unsuccessful write attempt: ", th);
                        }
                        break block28;
                    }
                    try {
                        out.close();
                        break block28;
                    }
                    catch (IOException e2) {
                        throw new EXEncoderException("Problem while closing File Stream after unsuccessful write attempt: ", e2);
                    }
                }
                catch (RuntimeException e) {
                    try {
                        rtEx = e;
                        break block28;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (rtEx != null || err != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable th) {
                                logger.error("Problem while closing File Stream after unsuccessful write attempt: ", th);
                            }
                        } else {
                            try {
                                out.close();
                            }
                            catch (IOException e3) {
                                throw new EXEncoderException("Problem while closing File Stream after unsuccessful write attempt: ", e3);
                            }
                        }
                    }
                }
                if (rtEx == null && err == null) break block29;
                try {
                    out.close();
                }
                catch (Throwable th) {
                    logger.error("Problem while closing File Stream after unsuccessful write attempt: ", th);
                }
                break block28;
            }
            try {
                out.close();
            }
            catch (IOException e) {
                throw new EXEncoderException("Problem while closing File Stream after unsuccessful write attempt: ", e);
            }
        }
        if (rtEx != null) {
            throw rtEx;
        }
        if (err != null) {
            throw err;
        }
    }

    public static final WriteContext openXMLStreamInNonARCWAYFormat(OutputStream out, boolean formatOutput) throws EXEncoderException {
        return EncodableObjectBase.openXMLStream(out, ENCODING_UTF_8, formatOutput, false);
    }

    public static final WriteContext openXMLStream(OutputStream out, boolean formatOutput) throws EXEncoderException {
        return EncodableObjectBase.openXMLStream(out, ENCODING_UTF_8, formatOutput);
    }

    public static final WriteContext openXMLStream(OutputStream out, String encoding, boolean formatOutput) throws EXEncoderException {
        return EncodableObjectBase.openXMLStream(out, encoding, formatOutput, true);
    }

    private static final WriteContext openXMLStream(OutputStream out, String encoding, boolean formatOutput, boolean arcwayFormat) throws EXEncoderException {
        OutputStreamWriteContext outp;
        try {
            outp = new OutputStreamWriteContext(out, encoding, false);
        }
        catch (UnsupportedEncodingException e) {
            throw new EXEncoderException("unknown encoding type " + encoding, e);
        }
        EncodableObjectBase.writeXMLHeader(outp, formatOutput, arcwayFormat);
        return outp;
    }

    public static final void closeXMLStream(WriteContext writeContext) throws EXEncoderException {
        try {
            writeContext.close();
        }
        catch (IOException e) {
            throw new EXEncoderException(e.getLocalizedMessage(), e);
        }
    }

    private static final void writeXMLHeader(WriteContext outp, boolean formatOutput, boolean arcwayFormat) throws EXEncoderException {
        EncodableObjectBase.writeProcessingInstruction(outp, "xml", "version=\"1.0\" encoding=\"" + outp.getEncoding() + "\"", formatOutput);
        if (arcwayFormat && !outp.areAttributeValuesToBeURLEncoded()) {
            if (outp.areAttributeValuesToBeURLEncoded()) {
                EncodableObjectBase.writeProcessingInstruction(outp, XML_INSTRUCTION_TARGET, XML_INSTRUCTION_ACTIVATE_ATTRIBUTE_VALUE_URLENCODEDING, formatOutput);
            } else {
                EncodableObjectBase.writeProcessingInstruction(outp, XML_INSTRUCTION_TARGET, XML_INSTRUCTION_DEACTIVATE_ATTRIBUTE_VALUE_URLENCODEDING, formatOutput);
            }
        }
    }

    public static final void writeProcessingInstruction(WriteContext outp, String target, String value, boolean formatOutput) throws EXEncoderException {
        EncodableObjectBase.appendStringToXML(outp, "<?" + target + " " + value + "?>");
        if (formatOutput) {
            EncodableObjectBase.appendStringToXML(outp, "\n");
        }
    }

    public static int writeSplittedToXMLGetRootDepth(boolean formatOutput) {
        int rootdepth = formatOutput ? 0 : -1;
        return rootdepth;
    }

    public static int writeSplittedToXMLGetChildDepth(int parentDepth) {
        int childDepth = parentDepth >= 0 ? parentDepth + 1 : -1;
        return childDepth;
    }

    public final void writeXMLBody(WriteContext outp, boolean formatOutput) throws EXEncoderException {
        int rootdepth = formatOutput ? 0 : -1;
        this.writeXMLBody(outp, rootdepth);
    }

    public final void writeXMLBody(final WriteContext outp, final int depth) throws EXEncoderException {
        this.writeSplittedToXMLOpenElementStartTagAndWriteAttributes(outp, depth);
        if (!this.hasChildrenFromBase() && !this.hasContentFromBase()) {
            EncodableObjectBase.writeSplittedToXMLCloseElementStartTagAndElement(outp, depth);
        } else {
            boolean enterSingleLineMode = this.hasContentFromBase();
            outp.process(enterSingleLineMode, new IEncoderProcessor(){

                @Override
                public void process(boolean singleLineMode) throws EXEncoderException {
                    EncodableObjectBase.writeSplittedToXMLCloseElementStartTag(outp, depth, singleLineMode);
                    EncodableObjectBase.this.writeSplittedToXMLWriteContentAndChildren(outp, depth, singleLineMode);
                    EncodableObjectBase.this.writeSplittedToXMLCloseElement(outp, depth, singleLineMode);
                }
            });
        }
    }

    public final void writeSplittedToXMLOpenElement(WriteContext outp, int depth, boolean singleLine) throws EXEncoderException {
        this.writeSplittedToXMLOpenElementStartTagAndWriteAttributes(outp, depth);
        EncodableObjectBase.writeSplittedToXMLCloseElementStartTag(outp, depth, singleLine);
    }

    private void writeSplittedToXMLOpenElementStartTagAndWriteAttributes(WriteContext outp, int depth) throws EXEncoderException {
        if (depth >= 0) {
            this.appendIndentToXML(outp, depth);
        }
        EncodableObjectBase.appendStringToXML(outp, "<");
        EncodableObjectBase.appendStringToXML(outp, this.getTag());
        this.appendAttributesToXMLFromBase(outp);
    }

    private static void writeSplittedToXMLCloseElementStartTagAndElement(WriteContext outp, int depth) throws EXEncoderException {
        EncodableObjectBase.appendStringToXML(outp, "/>");
        if (depth >= 0) {
            EncodableObjectBase.appendStringToXML(outp, "\n");
        }
    }

    private static void writeSplittedToXMLCloseElementStartTag(WriteContext outp, int depth, boolean singleLine) throws EXEncoderException {
        EncodableObjectBase.appendStringToXML(outp, ">");
        if (!singleLine && depth >= 0) {
            EncodableObjectBase.appendStringToXML(outp, "\n");
        }
    }

    public final void writeSplittedToXMLWriteContentAndChildren(WriteContext outp, int depth, boolean singleLine) throws EXEncoderException {
        if (!singleLine && depth >= 0) {
            this.writeContentAndChildrenToXMLFromBase(outp, depth + 1);
        } else {
            this.writeContentAndChildrenToXMLFromBase(outp, -1);
        }
    }

    public final void writeSplittedToXMLCloseElement(WriteContext outp, int depth, boolean singleLine) throws EXEncoderException {
        if (!singleLine && depth >= 0) {
            this.appendIndentToXML(outp, depth);
        }
        EncodableObjectBase.appendStringToXML(outp, "</");
        EncodableObjectBase.appendStringToXML(outp, this.getTag());
        EncodableObjectBase.appendStringToXML(outp, ">");
        if (depth >= 0) {
            EncodableObjectBase.appendStringToXML(outp, "\n");
        }
    }

    public final void setAttribute(String name, String value) {
        if (!this.setAttributeFromXMLFromBase(name, value)) {
            this.setUnknownAttributeFromBase(name, value);
        }
    }

    public final void addChild(EncodableObjectBase newChild) {
        if (!this.addChildFromXMLFromBase(newChild)) {
            this.addUnknownChildFromBase(newChild);
        }
    }

    public final void addContent(String value) throws EXDecoderException {
        if (!this.addContentFromXMLFromBase(value)) {
            this.addUnknownContentFromXMLFromBase(value);
        }
    }

    public final void destroy() {
    }

    abstract void appendAttributesToXMLFromBase(WriteContext var1) throws EXEncoderException;

    abstract boolean setAttributeFromXMLFromBase(String var1, String var2);

    abstract boolean hasChildrenFromBase();

    abstract void writeContentAndChildrenToXMLFromBase(WriteContext var1, int var2) throws EXEncoderException;

    abstract boolean addChildFromXMLFromBase(EncodableObjectBase var1);

    abstract boolean hasContentFromBase();

    abstract boolean addContentFromXMLFromBase(String var1);

    void setUnknownAttributeFromBase(String name, String value) {
    }

    void addUnknownChildFromBase(EncodableObjectBase newChild) {
    }

    void addUnknownContentFromXMLFromBase(String value) {
    }

    abstract void beginReadingBinaryContentFromBase() throws EXDecoderException;

    abstract void readPartOfBinaryContentFromBase(char[] var1, int var2, int var3) throws EXDecoderException;

    abstract void endReadingBinaryContentFromBase() throws EXDecoderException;

    abstract boolean canHaveBinaryContentFromBase();

    protected void appendIndentToXML(WriteContext outp, int depth) throws EXEncoderException {
        switch (depth) {
            case 0: {
                break;
            }
            case 1: {
                EncodableObjectBase.appendStringToXML(outp, "\t");
                break;
            }
            case 2: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t");
                break;
            }
            case 3: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t");
                break;
            }
            case 4: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t");
                break;
            }
            case 5: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t");
                break;
            }
            case 6: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t");
                break;
            }
            case 7: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t\t");
                break;
            }
            case 8: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t\t\t");
                break;
            }
            case 9: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t\t\t\t");
                break;
            }
            case 10: {
                EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t\t\t\t\t");
                break;
            }
            default: {
                if (depth >= 10) {
                    EncodableObjectBase.appendStringToXML(outp, "\t\t\t\t\t\t\t\t\t\t");
                    this.appendIndentToXML(outp, depth - 10);
                    break;
                }
                assert (false) : "Can not produce negative indent.";
                break;
            }
        }
    }

    static interface IEncoderProcessor {
        public void process(boolean var1) throws EXEncoderException;
    }

    public static final class OutputStreamWriteContext
    extends WriteContext {
        private final OutputStreamWriter outputStreamWriter;

        private OutputStreamWriteContext(OutputStream outputStream, String encoding, boolean areAttributeValuesToBeURLEncoded) throws UnsupportedEncodingException {
            super(encoding, areAttributeValuesToBeURLEncoded);
            this.outputStreamWriter = new OutputStreamWriter(outputStream, encoding);
        }

        @Override
        void write(String string) throws IOException {
            this.outputStreamWriter.write(string);
        }

        @Override
        void close() throws IOException {
            IOException flushIoEx = null;
            try {
                this.outputStreamWriter.flush();
            }
            catch (IOException ioex) {
                flushIoEx = ioex;
            }
            this.outputStreamWriter.close();
            if (flushIoEx != null) {
                throw flushIoEx;
            }
        }

        @Override
        public void writeRawData(Reader source) throws IOException {
            try {
                DataCopyHelper.copyCharactersLeavingDestinationOpen(source, this.outputStreamWriter);
            }
            catch (JvmExternalResourceInteractionException e) {
                throw e.toIOException();
            }
        }
    }

    static class ReadContext {
        private boolean attributeValuesAreURLEncoded;

        public ReadContext(boolean areAttributeValuesByDefaultURLEncoded) {
            this.attributeValuesAreURLEncoded = areAttributeValuesByDefaultURLEncoded;
        }

        public boolean areAttributeValuesURLEncoded() {
            return this.attributeValuesAreURLEncoded;
        }

        public void setAttributeValuesAreURLEncoded(boolean attributeValuesAreURLEncoded) {
            this.attributeValuesAreURLEncoded = attributeValuesAreURLEncoded;
        }
    }

    public static final class StringArrayListWriteContext
    extends WriteContext {
        private String[] strings = new String[500];
        private int nextWritePos = 0;
        private int cummulatedResultLength = 0;

        private StringArrayListWriteContext(String encoding, boolean areAttributeValuesToBeURLEncoded) {
            super(encoding, areAttributeValuesToBeURLEncoded);
        }

        @Override
        void write(String string) throws IOException {
            int stringsLength = this.strings.length;
            if (this.nextWritePos == stringsLength) {
                String[] moreStrings = new String[stringsLength * 2];
                System.arraycopy(this.strings, 0, moreStrings, 0, stringsLength);
                this.strings = moreStrings;
            }
            this.strings[this.nextWritePos] = string;
            this.cummulatedResultLength += string.length();
            ++this.nextWritePos;
        }

        @Override
        void close() throws IOException {
        }

        public String getBufferContentsAsString() {
            char[] result = new char[this.cummulatedResultLength];
            int resultWritePos = 0;
            int pos = 0;
            while (pos < this.nextWritePos) {
                String s = this.strings[pos];
                int slength = s.length();
                s.getChars(0, slength, result, resultWritePos);
                resultWritePos += slength;
                ++pos;
            }
            return new String(result);
        }
    }

    public static abstract class WriteContext {
        private final String encoding;
        private final boolean areAttributeValuesToBeURLEncoded;
        private boolean singleLineMode = false;

        public WriteContext(String encoding, boolean areAttributeValuesToBeURLEncoded) {
            this.encoding = encoding;
            this.areAttributeValuesToBeURLEncoded = areAttributeValuesToBeURLEncoded;
        }

        public void writeRawString(String string) throws IOException {
            this.write(string);
        }

        public void writeRawData(Reader source) throws IOException {
            char[] buf = new char[65536];
            int read = source.read(buf);
            while (read >= 0) {
                if (read > 0) {
                    this.write(new String(buf, 0, read));
                }
                read = source.read(buf);
            }
            source.close();
        }

        abstract void write(String var1) throws IOException;

        abstract void close() throws IOException;

        String getEncoding() {
            return this.encoding;
        }

        private boolean areAttributeValuesToBeURLEncoded() {
            return this.areAttributeValuesToBeURLEncoded;
        }

        public boolean isSingleLineMode() {
            return this.singleLineMode;
        }

        public void process(boolean enterSingleLineMode, IEncoderProcessor encoderProcessor) throws EXEncoderException {
            boolean oldMode = this.singleLineMode;
            try {
                this.singleLineMode = oldMode || enterSingleLineMode;
                encoderProcessor.process(this.singleLineMode);
            }
            finally {
                this.singleLineMode = oldMode;
            }
        }
    }
}

