/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.encoding.EXEncoderException;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.XMLContext;

public class EOValueNullable
extends EOEncodableObject {
    public static final String XML_NAME = "ValueNullable";
    private String value;
    private boolean isNull = false;

    public EOValueNullable(XMLContext xmlContext) {
        super(XML_NAME, xmlContext);
        this.isNull = true;
    }

    public EOValueNullable() {
        super(XML_NAME);
        this.isNull = true;
    }

    public EOValueNullable(String value) {
        super(XML_NAME);
        if (value == null) {
            this.isNull = true;
        } else {
            this.value = value;
            this.isNull = false;
        }
    }

    @Override
    protected void appendAttributesToXML(EncodableObjectBase.WriteContext writeContext) throws EXEncoderException {
        if (!this.isNull) {
            this.appendAttrToXML(writeContext, "value", this.value);
        } else {
            this.appendAttrToXML(writeContext, "isNull", this.isNull);
        }
    }

    @Override
    protected boolean setAttributeFromXML(String name, String value) {
        boolean success = true;
        if (name.equals("isNull")) {
            this.isNull = this.toBoolean(value);
        } else if (name.equals("value")) {
            this.value = value;
            this.isNull = false;
        } else {
            success = false;
        }
        return success;
    }

    @Override
    protected boolean hasChildren() {
        return false;
    }

    @Override
    protected void writeChildrenToXML(EncodableObjectBase.WriteContext writeContext, int depth) throws EXEncoderException {
    }

    @Override
    protected boolean addChildFromXML(EncodableObjectBase newChild) {
        return false;
    }

    public String getValue() {
        return this.value;
    }

    public int getIntValue() {
        return Integer.parseInt(this.value);
    }

    public long getLongValue() {
        return Long.parseLong(this.value);
    }

    public double getDoubleValue() {
        return Double.parseDouble(this.value);
    }

    public float getFloatValue() {
        return Float.parseFloat(this.value);
    }

    public boolean getBooleanValue() {
        return this.value.equalsIgnoreCase("true");
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public void setValue(String value) {
        this.value = value;
        this.isNull = value == null;
    }

    public void setValue(int value) {
        this.value = Integer.toString(value);
    }

    public void setValue(long value) {
        this.value = Long.toString(value);
    }

    public void setValue(double value) {
        this.value = Double.toString(value);
    }

    public void setValue(float value) {
        this.value = Float.toString(value);
    }

    public void setValue(boolean value) {
        this.value = Boolean.toString(value);
    }

    public String toString() {
        return this.value;
    }

    public void setNull(boolean isNull) {
        this.isNull = isNull;
    }
}

