/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.xml.encoding;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.EncodableObjectBase;
import de.plans.lib.xml.encoding.IEncodableObjectFactory;
import de.plans.lib.xml.encoding.XMLContext;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Set;

public abstract class AbstractEncodableObjectFactory
implements IEncodableObjectFactory {
    private static final ILogger logger = Logger.getLogger(AbstractEncodableObjectFactory.class);
    private final Hashtable<String, IFactory> eoClassConstructors = new Hashtable(50, 0.4f);
    private final Set<String> xmlTagNames = Collections.unmodifiableSet(this.eoClassConstructors.keySet());

    public Set<String> getXMLTagNames() {
        return this.xmlTagNames;
    }

    public void addConstructor(String xmlName, IFactory eoClass) {
        try {
            if (!this.eoClassConstructors.contains(xmlName)) {
                this.eoClassConstructors.put(xmlName, eoClass);
            }
        }
        catch (SecurityException e) {
            logger.fatal("AbstractEncodableObjectFactory() - SecurityException when setting up message constructors.", e);
        }
    }

    @Override
    public EncodableObjectBase createEncodableObject(String name, XMLContext context) {
        IFactory eoClassConstructor = this.eoClassConstructors.get(name);
        if (eoClassConstructor != null) {
            try {
                return eoClassConstructor.createEO(context);
            }
            catch (SecurityException e) {
                logger.error("createEncodableObject(name = " + name + ") - Security Exception when creating encodable object. ", e);
            }
            catch (IllegalArgumentException e) {
                logger.error("createEncodableObject(name = " + name + ") - IllegalArgumentException when creating encodable object. ", e);
            }
        }
        return null;
    }

    public static interface IFactory {
        public EncodableObjectBase createEO(XMLContext var1);
    }
}

