/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.util;

import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.ILoggerManager;
import de.plans.lib.PSLibPlugIn;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class EclipseLoggerManager
implements ILoggerManager {
    @Override
    public ILogger getILogger(String name) {
        return new WorkbenchLogAdapter(null, name);
    }

    public ILogger getILogger(Class clazz) {
        String pluginId = null;
        return new WorkbenchLogAdapter(pluginId, clazz.getName());
    }

    public static class ArcwayEclipseLoggerStatus
    extends Status {
        public ArcwayEclipseLoggerStatus(int severity, String pluginId, int code, String message, Throwable exception) {
            super(severity, pluginId, code, message, exception);
        }
    }

    private static class WorkbenchLogAdapter
    implements ILogger {
        private static final int TRACE_CODE = 10;
        private static final int DEBUG_CODE = 20;
        private static final int INFO_CODE = 30;
        private static final int WARN_CODE = 40;
        private static final int ERROR_CODE = 50;
        private static final int FATAL_CODE = 60;
        private static boolean traceEnabled = false;
        private static boolean debugEnabled = false;
        private static boolean infoEnabled = true;
        private static boolean warnEnabled = true;
        private static boolean errorEnabled = true;
        private static boolean fatalEnabled = true;
        private final String loggerName;
        private final String pluginID;

        public WorkbenchLogAdapter(String pluginId, String name) {
            this.loggerName = name;
            this.pluginID = pluginId;
        }

        private void log(int severity, int code, String message, Throwable exception) {
            String messageToLog;
            String pluginIDToLog;
            if (this.pluginID == null) {
                pluginIDToLog = this.loggerName;
                messageToLog = message;
            } else {
                pluginIDToLog = this.pluginID;
                messageToLog = String.valueOf(this.loggerName) + ":\n" + message;
            }
            PSLibPlugIn.getDefault().getLog().log((IStatus)new ArcwayEclipseLoggerStatus(severity, pluginIDToLog, code, messageToLog, exception));
        }

        @Override
        public void trace(String message) {
            if (traceEnabled) {
                this.log(1, 10, message, null);
            }
        }

        @Override
        public void debug(int debugCategory, String message) {
            if (debugEnabled) {
                this.log(1, debugCategory <= 0 ? debugCategory : -1 * debugCategory, message, null);
            }
        }

        @Override
        public void debug(String message) {
            if (debugEnabled) {
                this.log(1, 20, message, null);
            }
        }

        @Override
        public void debug(String message, Throwable t) {
            if (debugEnabled) {
                this.log(1, 20, message, t);
            }
        }

        @Override
        public void debug(int debugCategory, String message, Throwable t) {
            if (debugEnabled) {
                this.log(1, debugCategory <= 0 ? debugCategory : -1 * debugCategory, message, t);
            }
        }

        @Override
        public void error(String message) {
            if (errorEnabled) {
                this.log(4, 50, message, null);
            }
        }

        @Override
        public void error(String message, Throwable t) {
            if (errorEnabled) {
                this.log(4, 50, message, t);
            }
        }

        @Override
        public void error(Throwable t) {
            if (errorEnabled) {
                this.log(4, 50, "", t);
            }
        }

        @Override
        public void fatal(String message) {
            if (fatalEnabled) {
                this.log(4, 60, message, null);
            }
        }

        @Override
        public void fatal(String message, Throwable t) {
            if (fatalEnabled) {
                this.log(4, 60, message, t);
            }
        }

        @Override
        public void fatal(Throwable t) {
            if (fatalEnabled) {
                this.log(4, 60, "", t);
            }
        }

        @Override
        public void info(String message) {
            if (infoEnabled) {
                this.log(1, 30, message, null);
            }
        }

        @Override
        public void info(String message, Throwable t) {
            if (infoEnabled) {
                this.log(1, 30, message, t);
            }
        }

        @Override
        public void warn(String message) {
            if (warnEnabled) {
                this.log(2, 40, message, null);
            }
        }

        @Override
        public void warn(String message, Throwable t) {
            if (warnEnabled) {
                this.log(2, 40, message, t);
            }
        }

        @Override
        public void warn(Throwable t) {
            if (warnEnabled) {
                this.log(2, 40, "", t);
            }
        }

        @Override
        public boolean isInfoEnabled() {
            return infoEnabled;
        }

        @Override
        public boolean isDebugEnabled() {
            return debugEnabled;
        }

        @Override
        public boolean isDebugEnabled(int debugCategory) {
            return debugEnabled;
        }

        @Override
        public boolean isTraceEnabled() {
            return traceEnabled;
        }
    }
}

