/*
 * Decompiled with CFR 0.152.
 */
package de.plans.lib.lic;

import com.arcway.lib.java.collectionmaps.ListMap;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.network.HostNameRetriever;
import de.plans.lib.lic.ModuleLicense;
import de.plans.lib.lic.UserLicense;
import de.plans.lib.security.Security;
import de.plans.lib.util.Crypt;
import de.plans.lib.util.Hex;
import de.plans.lib.util.PasswordEncoder2;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LicenseFileReader {
    private static final int LOGGER_DEBUG_CATEGORY = 170;
    private static final ILogger logger;
    static final String SERVER_TAG = "server ";
    static final String HOST_ID_TAG = "hostID";
    static final String HOST_Name_TAG = "hostname";
    static final String DNS_Name_TAG = "dnsname";
    static final String HOST_UserName_TAG = "os.username";
    public static final String RELATIVE_DIRECTORY = "Licenses";
    public static final String INDEPENDANT_ADDITIONAL_MODULE_ID = "independant-additional-module";
    private static final String ATTACHED_TO_IP_STRING = "attached to IP";
    private static final String ATTACHED_TO_IP_RANGE_STRING = "attached to IP range";
    private static final String ATTACHED_TO_IPV6_STRING = "attached to IPv6";
    private static final String ATTACHED_TO_IPV6_RANGE_STRING = "attached to IPv6 range";
    private static final ArrayList<int[]> localIPAddressesInIP4;
    private static final ArrayList<int[]> localIPAddressesInIP6;
    private static final String PRODUCT_ID_COCKPIT_2_CS_FULL = "COCKPIT-2";
    private static final String PRODUCT_ID_COCKPIT_3_CS_FULL = "COCKPIT-3";
    private static final String PRODUCT_ID_COCKPIT_35_CS_FULL = "COCKPIT-3.5";

    static {
        block10: {
            logger = Logger.getLogger(LicenseFileReader.class);
            localIPAddressesInIP4 = new ArrayList();
            localIPAddressesInIP6 = new ArrayList();
            try {
                try {
                    Enumeration<NetworkInterface> enumerator = NetworkInterface.getNetworkInterfaces();
                    while (enumerator.hasMoreElements()) {
                        NetworkInterface intf = enumerator.nextElement();
                        ArrayList<int[]> ipV4Addresses = localIPAddressesInIP4;
                        ArrayList<int[]> ipV6Addresses = localIPAddressesInIP6;
                        Enumeration<InetAddress> addresses = intf.getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress adr = addresses.nextElement();
                            LicenseFileReader.addIPAddress(adr, ipV4Addresses, ipV6Addresses);
                        }
                    }
                }
                catch (Throwable th) {
                    logger.error("Error while detecting License Server Host IP address(es)", th);
                    if (localIPAddressesInIP4.size() == 0 && localIPAddressesInIP6.size() == 0) {
                        logger.error("Error while detecting License Server Host IP address(es) - no IP address could be detected - adding loopback interface address 127.0.0.1.");
                        int[] nArray = new int[4];
                        nArray[0] = 127;
                        nArray[3] = 1;
                        localIPAddressesInIP4.add(nArray);
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (localIPAddressesInIP4.size() == 0 && localIPAddressesInIP6.size() == 0) {
                    logger.error("Error while detecting License Server Host IP address(es) - no IP address could be detected - adding loopback interface address 127.0.0.1.");
                    int[] nArray = new int[4];
                    nArray[0] = 127;
                    nArray[3] = 1;
                    localIPAddressesInIP4.add(nArray);
                }
                throw throwable;
            }
            if (localIPAddressesInIP4.size() == 0 && localIPAddressesInIP6.size() == 0) {
                logger.error("Error while detecting License Server Host IP address(es) - no IP address could be detected - adding loopback interface address 127.0.0.1.");
                int[] nArray = new int[4];
                nArray[0] = 127;
                nArray[3] = 1;
                localIPAddressesInIP4.add(nArray);
            }
        }
    }

    private static void addIPAddresses(InetAddress[] addresses, ArrayList<int[]> ipV4Addresses, ArrayList<int[]> ipV6Addresses) {
        InetAddress[] inetAddressArray = addresses;
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress adr = inetAddressArray[n2];
            LicenseFileReader.addIPAddress(adr, ipV4Addresses, ipV6Addresses);
            ++n2;
        }
    }

    private static void addIPAddress(InetAddress adr, ArrayList<int[]> ipV4Addresses, ArrayList<int[]> ipV6Addresses) {
        if (adr instanceof Inet4Address) {
            byte[] adrAsBytes = adr.getAddress();
            ipV4Addresses.add(new int[]{adrAsBytes[0] >= 0 ? adrAsBytes[0] : adrAsBytes[0] + 256, adrAsBytes[1] >= 0 ? adrAsBytes[1] : adrAsBytes[1] + 256, adrAsBytes[2] >= 0 ? adrAsBytes[2] : adrAsBytes[2] + 256, adrAsBytes[3] >= 0 ? adrAsBytes[3] : adrAsBytes[3] + 256});
        } else if (adr instanceof Inet6Address) {
            byte[] adrAsBytes = adr.getAddress();
            int[] adrAsInts = new int[(adrAsBytes.length + 1) / 2];
            int i = adrAsBytes.length - 1;
            while (i >= 0) {
                int adrAsInt;
                int n = adrAsInt = adrAsBytes[i] >= 0 ? adrAsBytes[i] : adrAsBytes[i] + 256;
                if (i > 0) {
                    adrAsInt += (adrAsBytes[i - 1] >= 0 ? adrAsBytes[i - 1] : adrAsBytes[i - 1] + 256) * 256;
                }
                adrAsInts[i / 2] = adrAsInt;
                i -= 2;
            }
            ipV6Addresses.add(adrAsInts);
        }
    }

    private LicenseFileReader() {
    }

    public static String readLicenseFiles(File rootPath, Map<String, UserLicense> allowedNumberOfUsersReference, MapMap<String, String, ModuleLicense> allowedModulesReference) {
        File licenseFileDirectory = null;
        licenseFileDirectory = LicenseFileReader.getLicenseDirForRootPath(rootPath);
        LicenseFileReaderStatus status = new LicenseFileReaderStatus();
        LicenseFileReader.readLicensesFromDirectory(Arrays.asList(licenseFileDirectory), null, allowedNumberOfUsersReference, allowedModulesReference, status);
        return status.getStatusHTML();
    }

    public static LicenseFileReaderStatus readLicenseFiles(Collection<File> licenseFileDirectories, Date installDate, Map<String, UserLicense> allowedNumberOfUsersReference, MapMap<String, String, ModuleLicense> allowedModulesReference) {
        LicenseFileReaderStatus status = new LicenseFileReaderStatus();
        LicenseFileReader.readLicensesFromDirectory(licenseFileDirectories, installDate, allowedNumberOfUsersReference, allowedModulesReference, status);
        return status;
    }

    private static File getLicenseDirForRootPath(File rootPath) {
        File licenseFileDirectory = new File(rootPath, RELATIVE_DIRECTORY);
        return licenseFileDirectory;
    }

    private static void readLicensesFromDirectory(Collection<File> licenseFileDirectories, Date installDate, Map<String, UserLicense> allowedNumberOfUsersReference, MapMap<String, String, ModuleLicense> allowedModulesReference, LicenseFileReaderStatus status) {
        HashSet<String> readLicenseFiles = new HashSet<String>();
        for (File directory : licenseFileDirectories) {
            if (!directory.exists() || !directory.isDirectory()) {
                logger.debug(170, "License Server: License file directory \"" + directory.getAbsoluteFile() + "\" does not exist!");
                continue;
            }
            if (!directory.canRead()) {
                logger.warn("License Server: License file directory \"" + directory.getAbsoluteFile() + "\" can not be read!");
                continue;
            }
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File fileToLoad = fileArray[n2];
                if (fileToLoad.isFile()) {
                    boolean validOld;
                    boolean valid;
                    logger.debug(170, "License Server: Analyzing file \"" + fileToLoad.getName() + "\"");
                    try {
                        valid = Security.verifySignature(fileToLoad, 170);
                        validOld = false;
                    }
                    catch (Security.EXOldSignature e) {
                        valid = false;
                        validOld = true;
                    }
                    if (valid || validOld) {
                        LicenseFileReaderLicenseFileStatus fileStatus = LicenseFileReader.readLicenseFile(fileToLoad, installDate, readLicenseFiles, allowedNumberOfUsersReference, allowedModulesReference, validOld);
                        if (fileStatus != null) {
                            status.addLicenseFileStatus(directory, fileStatus);
                        }
                    } else {
                        logger.debug(170, "File " + fileToLoad + " is probably not a license file - will be skipped.");
                    }
                }
                ++n2;
            }
        }
    }

    private static LicenseFileReaderLicenseFileStatus readLicenseFile(File licenseFile, Date installDate, Set<String> readLicenseFiles, Map<String, UserLicense> allowedNumberOfUsers, MapMap<String, String, ModuleLicense> allowedModules, boolean validOld) {
        BufferedReader reader = null;
        FileInputStream byteStream = null;
        try {
            byteStream = new FileInputStream(licenseFile);
            reader = new BufferedReader(new InputStreamReader(byteStream));
            if (!reader.ready()) {
                return null;
            }
            int signatureLength = ((InputStream)byteStream).read();
            byte[] buffer = new byte[signatureLength + 2];
            if (buffer.length != ((InputStream)byteStream).read(buffer)) {
                logger.debug("License Server: Premature end of license file detected.");
                return null;
            }
            String licenseFileID = reader.readLine();
            LicenseFileReaderLicenseFileStatus fileStatus = new LicenseFileReaderLicenseFileStatus();
            fileStatus.licenseFile = licenseFile;
            fileStatus.licenseFileID = licenseFileID;
            if (readLicenseFiles.contains(licenseFileID)) {
                logger.debug("License Server: Duplicate license file id");
                fileStatus.problems.add("Duplicate license file ID");
            } else {
                readLicenseFiles.add(licenseFileID);
                if (reader.ready()) {
                    String serverLine = reader.readLine();
                    while (serverLine != null) {
                        if (LicenseFileReader.checkFirstLine(serverLine, fileStatus)) {
                            ValidityDefinition validityDefinition;
                            String validFromDateLine = reader.readLine();
                            if (LicenseFileReader.checkValidFromDate(validFromDateLine, validityDefinition = new ValidityDefinition(), fileStatus)) {
                                String expiryDateLine = reader.readLine();
                                if (LicenseFileReader.checkExpiryDate(expiryDateLine, installDate, validityDefinition, fileStatus)) {
                                    serverLine = LicenseFileReader.readLicenseFileSection(reader, validityDefinition, allowedNumberOfUsers, allowedModules, fileStatus, validOld);
                                    continue;
                                }
                                logger.debug(170, "License Server: skipping expired section (" + serverLine + "): " + expiryDateLine);
                                serverLine = LicenseFileReader.skipLicenseFileSection(reader);
                                continue;
                            }
                            logger.debug(170, "License Server: skipping not yet valid section (" + serverLine + "): " + validFromDateLine);
                            reader.readLine();
                            serverLine = LicenseFileReader.skipLicenseFileSection(reader);
                            continue;
                        }
                        logger.debug(170, "License Server: skipping section (" + serverLine + ")");
                        serverLine = LicenseFileReader.skipLicenseFileSection(reader);
                    }
                }
            }
            LicenseFileReaderLicenseFileStatus licenseFileReaderLicenseFileStatus = fileStatus;
            return licenseFileReaderLicenseFileStatus;
        }
        catch (IOException ioE) {
            logger.error("License Server: I/O-Error while reading license file " + licenseFile.getName() + ": " + ioE.getClass().getName() + ": " + ioE.getMessage() + ".", ioE);
            return null;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error("Exception when closing reader for license file", e);
            }
        }
    }

    private static boolean checkFirstLine(String serverLine, LicenseFileReaderLicenseFileStatus status) {
        if (serverLine.startsWith(SERVER_TAG)) {
            return LicenseFileReader.checkIPAddress(serverLine, status);
        }
        if (serverLine.startsWith(HOST_ID_TAG)) {
            return LicenseFileReader.checkHostID(serverLine, status);
        }
        if (serverLine.startsWith(HOST_Name_TAG)) {
            return LicenseFileReader.checkHostName(serverLine, status);
        }
        if (serverLine.startsWith(DNS_Name_TAG)) {
            return LicenseFileReader.checkDNSName(serverLine, status);
        }
        if (serverLine.startsWith(HOST_UserName_TAG)) {
            return LicenseFileReader.checkUserName(serverLine, status);
        }
        logger.warn("License Server: Invalid server line in license file (does not start correctly): " + serverLine);
        status.problems.add("Invalid start of server line in license file");
        return false;
    }

    private static boolean checkIPAddress(String p_serverLine, LicenseFileReaderLicenseFileStatus status) {
        String serverLine;
        block22: {
            block21: {
                block19: {
                    String[] IPAddressArray;
                    block20: {
                        block16: {
                            String[] lastIPAddressArray;
                            String[] firstIPAddressArray;
                            block18: {
                                String firstIPAddress;
                                block17: {
                                    serverLine = p_serverLine;
                                    if (!serverLine.startsWith(SERVER_TAG)) {
                                        logger.warn("License Server: Invalid server line in license file (does not start with \"server\"): " + serverLine);
                                        status.problems.add("Invalid file format (IP address)");
                                        return false;
                                    }
                                    if ((serverLine = serverLine.substring(SERVER_TAG.length()).trim()).indexOf(32) < 0) {
                                        logger.warn("License Server: Invalid server line in license file (missing servername): " + serverLine);
                                        status.problems.add("Invalid file format (IP address)");
                                        return false;
                                    }
                                    if (!(serverLine = serverLine.trim()).startsWith("attached")) {
                                        serverLine = serverLine.substring(serverLine.indexOf(32)).trim();
                                    }
                                    try {
                                        if (!serverLine.startsWith(ATTACHED_TO_IPV6_RANGE_STRING)) break block16;
                                        serverLine = serverLine.substring(ATTACHED_TO_IPV6_RANGE_STRING.length()).trim();
                                        firstIPAddress = serverLine.substring(0, serverLine.indexOf(45)).trim();
                                        String lastIPAddress = serverLine.substring(serverLine.indexOf(45) + 1).trim();
                                        firstIPAddressArray = firstIPAddress.split(":");
                                        lastIPAddressArray = lastIPAddress.split(":");
                                        if (lastIPAddressArray != null && lastIPAddressArray.length != 0) break block17;
                                        status.problems.add("IP in v6 has invalid format (" + lastIPAddress.trim() + ")");
                                        return false;
                                    }
                                    catch (Exception e) {
                                        logger.warn("License Server: Invalid server line in license file (failed to analyze IP address): " + e + ": " + e.getMessage());
                                        status.problems.add("Invalid file format (IP address)");
                                        return false;
                                    }
                                }
                                if (firstIPAddressArray != null && firstIPAddressArray.length != 0) break block18;
                                status.problems.add("IP in v6 has invalid format (" + firstIPAddress.trim() + ")");
                                return false;
                            }
                            if (!LicenseFileReader.compareIPv6Addresses(firstIPAddressArray, lastIPAddressArray, localIPAddressesInIP6)) {
                                status.problems.add("IP doesn't match ( should be between: " + serverLine.trim() + " / is: " + LicenseFileReader.getLocalIPAddressesAsString() + " )");
                                return false;
                            }
                            return true;
                        }
                        if (!serverLine.startsWith(ATTACHED_TO_IPV6_STRING)) break block19;
                        IPAddressArray = (serverLine = serverLine.substring(ATTACHED_TO_IPV6_STRING.length()).trim()).split(":");
                        if (IPAddressArray != null && IPAddressArray.length != 0) break block20;
                        status.problems.add("IP in v6 has invalid format (" + serverLine.trim() + ")");
                        return false;
                    }
                    if (!LicenseFileReader.compareIPv6Addresses(IPAddressArray, IPAddressArray, localIPAddressesInIP6)) {
                        status.problems.add("IP doesn't match ( should be: " + serverLine.trim() + " / is: " + LicenseFileReader.getLocalIPAddressesAsString() + " )");
                        return false;
                    }
                    return true;
                }
                if (!serverLine.startsWith(ATTACHED_TO_IP_RANGE_STRING)) break block21;
                serverLine = serverLine.substring(ATTACHED_TO_IP_RANGE_STRING.length()).trim();
                String firstIPAddress = serverLine.substring(0, serverLine.indexOf(45)).trim();
                String lastIPAddress = serverLine.substring(serverLine.indexOf(45) + 1).trim();
                String[] firstIPAddressArray = firstIPAddress.split("\\.");
                String[] lastIPAddressArray = lastIPAddress.split("\\.");
                if (!LicenseFileReader.compareIPv4Addresses(new int[]{Integer.parseInt(firstIPAddressArray[0]), Integer.parseInt(firstIPAddressArray[1]), Integer.parseInt(firstIPAddressArray[2]), Integer.parseInt(firstIPAddressArray[3])}, new int[]{Integer.parseInt(lastIPAddressArray[0]), Integer.parseInt(lastIPAddressArray[1]), Integer.parseInt(lastIPAddressArray[2]), Integer.parseInt(lastIPAddressArray[3])}, localIPAddressesInIP4)) {
                    status.problems.add("IP doesn't match ( should be between: " + serverLine.trim() + " / is: " + LicenseFileReader.getLocalIPAddressesAsString() + " )");
                    return false;
                }
                return true;
            }
            if (!serverLine.startsWith(ATTACHED_TO_IP_STRING)) break block22;
            String[] IPAddressArray = (serverLine = serverLine.substring(ATTACHED_TO_IP_STRING.length()).trim()).split("\\.");
            int[] IPAddressAsBytes = new int[]{Integer.parseInt(IPAddressArray[0]), Integer.parseInt(IPAddressArray[1]), Integer.parseInt(IPAddressArray[2]), Integer.parseInt(IPAddressArray[3])};
            if (!LicenseFileReader.compareIPv4Addresses(IPAddressAsBytes, IPAddressAsBytes, localIPAddressesInIP4)) {
                status.problems.add("IP doesn't match ( should be: " + serverLine.trim() + " / is: " + LicenseFileReader.getLocalIPAddressesAsString() + " )");
                return false;
            }
            return true;
        }
        logger.warn("License Server: Invalid server line in license file (missing \"is attached to\"): " + serverLine);
        status.problems.add("Invalid file format (IP address)");
        return false;
    }

    private static boolean compareIPAddresses(int[] lowestAddress, int[] highestAddress, List<int[]> targetAddresses, int pieces) {
        block0: for (int[] targetAddress : targetAddresses) {
            boolean matchesLowerBoundary = false;
            boolean matchesUpperBoundary = false;
            int c = 0;
            while (c < pieces) {
                if (targetAddress[c] < lowestAddress[c] && !matchesLowerBoundary || targetAddress[c] > highestAddress[c] && !matchesUpperBoundary) continue block0;
                if (targetAddress[c] > lowestAddress[c]) {
                    matchesLowerBoundary = true;
                }
                if (targetAddress[c] < highestAddress[c]) {
                    matchesUpperBoundary = true;
                }
                if (matchesLowerBoundary && matchesUpperBoundary || c == pieces - 1) {
                    return true;
                }
                ++c;
            }
        }
        return false;
    }

    private static boolean compareIPv4Addresses(int[] lowestAddress, int[] highestAddress, List<int[]> targetAddresses) {
        return LicenseFileReader.compareIPAddresses(lowestAddress, highestAddress, targetAddresses, 4);
    }

    private static boolean compareIPv6Addresses(String[] lowestAddressPieces, String[] highestAddressPieces, List<int[]> targetAddresses) {
        int[] lowestAdressAsInts = new int[8];
        int[] highestAdressAsInts = new int[8];
        int index = 0;
        while (index < 8) {
            lowestAdressAsInts[index] = Hex.parseInt(lowestAddressPieces[index]);
            highestAdressAsInts[index] = Hex.parseInt(highestAddressPieces[index]);
            ++index;
        }
        return LicenseFileReader.compareIPv6Addresses(lowestAdressAsInts, highestAdressAsInts, targetAddresses);
    }

    private static boolean compareIPv6Addresses(int[] lowestAdressAsInts, int[] highestAdressAsInts, List<int[]> targetAddresses) {
        return LicenseFileReader.compareIPAddresses(lowestAdressAsInts, highestAdressAsInts, targetAddresses, 8);
    }

    public static String getLocalIPAddressesAsString() {
        return LicenseFileReader.getIPAddressesAsString(localIPAddressesInIP4, localIPAddressesInIP6);
    }

    public static String getIPAddressesAsString(ArrayList<int[]> ipV4Addresses, ArrayList<int[]> ipV6Addresses) {
        String result = "";
        Iterator<int[]> addressIterator = ipV4Addresses.iterator();
        while (addressIterator.hasNext()) {
            int[] addressAsBytes = addressIterator.next();
            result = String.valueOf(result) + addressAsBytes[0] + "." + addressAsBytes[1] + "." + addressAsBytes[2] + "." + addressAsBytes[3];
            if (!addressIterator.hasNext() && ipV6Addresses.isEmpty()) continue;
            result = String.valueOf(result) + " or ";
        }
        addressIterator = ipV6Addresses.iterator();
        while (addressIterator.hasNext()) {
            int[] addressAsDoubleBytes = addressIterator.next();
            int index = 0;
            int[] nArray = addressAsDoubleBytes;
            int n = addressAsDoubleBytes.length;
            int n2 = 0;
            while (n2 < n) {
                int addressPiece = nArray[n2];
                if (index > 0) {
                    result = String.valueOf(result) + ":";
                }
                result = String.valueOf(result) + new String(Hex.asChars(addressPiece, 4));
                ++index;
                ++n2;
            }
            if (!addressIterator.hasNext()) continue;
            result = String.valueOf(result) + " or ";
        }
        return result;
    }

    private static boolean checkHostID(String serverLine, LicenseFileReaderLicenseFileStatus status) {
        boolean hostIdMatches;
        if (!serverLine.startsWith(HOST_ID_TAG)) {
            logger.warn("License Server: Invalid server line in license file (does not start with \"hostID\"): " + serverLine);
            status.problems.add("Invalid file format (Host ID)");
            return false;
        }
        String line = serverLine.substring(HOST_ID_TAG.length());
        String readHostID = line.trim();
        try {
            String localHostID2 = LicenseFileReader.getHostID2();
            String localHostID = LicenseFileReader.getHostID();
            hostIdMatches = LicenseFileReader.getHostID2().equals(readHostID);
            if (!hostIdMatches && !(hostIdMatches = LicenseFileReader.getHostID().equals(readHostID))) {
                status.problems.add("Host ID doesn't match ( should be: " + readHostID + " / is: " + localHostID2 + " )");
                logger.warn("License Server: Host ID (" + localHostID2 + " / old: " + localHostID + ") does not match ID in license file (" + readHostID + ")");
            }
        }
        catch (HostNameRetriever.UnableToRetrieveHostnameException e) {
            hostIdMatches = false;
            status.problems.add("Unable to verify that the Host ID in the license File matches that of the local host, because the name of the local host can not be retrieved. Host ID in license File was: " + readHostID);
            logger.warn("License Server: Unable to verify that the Host ID in the license File matches that of the local host, because the name of the local host can not be retrieved. Host ID in license File was: " + readHostID);
        }
        return hostIdMatches;
    }

    private static boolean checkHostName(String serverLine, LicenseFileReaderLicenseFileStatus status) {
        boolean hostNameMatches;
        if (!serverLine.startsWith(HOST_Name_TAG)) {
            logger.warn("License Server: Invalid server line in license file (does not start with \"hostname\"): " + serverLine);
            status.problems.add("Invalid file format (Host name)");
            return false;
        }
        String line = serverLine.substring(HOST_Name_TAG.length());
        String readHostname = line.trim();
        try {
            String localHostName = LicenseFileReader.getHostname();
            hostNameMatches = localHostName.equalsIgnoreCase(readHostname);
            if (!hostNameMatches) {
                status.problems.add("Hostname doesn't match ( should be: " + readHostname + " / is: " + localHostName + " )");
                logger.warn("License Server: Hostname (" + localHostName + ") does not match name in license file (" + readHostname + ")");
            }
        }
        catch (HostNameRetriever.UnableToRetrieveHostnameException e) {
            hostNameMatches = false;
            status.problems.add("Unable to verify that the host name in the license File matches that of the local host, because the name of the local host can not be retrieved. Host name in license File was: " + readHostname);
            logger.warn("License Server: Unable to verify that the host name in the license File matches that of the local host, because the name of the local host can not be retrieved. Host name in license File was: " + readHostname);
        }
        return hostNameMatches;
    }

    private static boolean checkDNSName(String serverLine, LicenseFileReaderLicenseFileStatus status) {
        boolean dnsNameMatches;
        if (!serverLine.startsWith(DNS_Name_TAG)) {
            logger.warn("License Server: Invalid server line in license file (does not start with \"dnsname\"): " + serverLine);
            status.problems.add("Invalid file format (DNS name)");
            return false;
        }
        String line = serverLine.substring(DNS_Name_TAG.length());
        String readDNSname = line.trim();
        try {
            ArrayList<int[]> dnsIPAddressesInIP4 = new ArrayList<int[]>();
            ArrayList<int[]> dnsIPAddressesInIP6 = new ArrayList<int[]>();
            InetAddress[] dnsAddresses = InetAddress.getAllByName(readDNSname);
            LicenseFileReader.addIPAddresses(dnsAddresses, dnsIPAddressesInIP4, dnsIPAddressesInIP6);
            dnsNameMatches = false;
            for (int[] dnsAddress : dnsIPAddressesInIP4) {
                boolean bl = dnsNameMatches = dnsNameMatches || LicenseFileReader.compareIPv4Addresses(dnsAddress, dnsAddress, localIPAddressesInIP4);
            }
            for (int[] dnsAddress : dnsIPAddressesInIP6) {
                boolean bl = dnsNameMatches = dnsNameMatches || LicenseFileReader.compareIPv6Addresses(dnsAddress, dnsAddress, localIPAddressesInIP6);
            }
            if (!dnsNameMatches) {
                String dnsAddressesAsString = LicenseFileReader.getIPAddressesAsString(dnsIPAddressesInIP4, dnsIPAddressesInIP6);
                String localAddressesAsString = LicenseFileReader.getLocalIPAddressesAsString();
                status.problems.add("DNS name " + readDNSname + " doesn't match ( IP should be one of: " + dnsAddressesAsString + " / is: " + localAddressesAsString + " )");
                logger.warn("License Server: DNS name " + readDNSname + " doens't match ( IP should be one of: " + dnsAddressesAsString + " / is: " + localAddressesAsString + " )");
            }
        }
        catch (UnknownHostException e) {
            dnsNameMatches = false;
            status.problems.add("Unable to verify that the dns name in the license File matches that of the local host, because the dns name of the local host can not be retrieved. DNS name in license File was: " + readDNSname);
            logger.warn("License Server: Unable to verify that the dns name in the license File matches that of the local host, because the dns name of the local host can not be retrieved. DNS name in license File was: " + readDNSname);
        }
        return dnsNameMatches;
    }

    private static boolean checkUserName(String serverLine, LicenseFileReaderLicenseFileStatus status) {
        if (!serverLine.startsWith(HOST_UserName_TAG)) {
            System.out.println("License Server: Invalid server line in license file (does not start with \"os.username\"): " + serverLine);
            status.problems.add("Invalid file format (User name)");
            return false;
        }
        String line = serverLine.substring(HOST_UserName_TAG.length());
        String readUsername = line.trim();
        String localOSUserName = System.getProperty("user.name", "");
        boolean userNameMatches = localOSUserName.equalsIgnoreCase(readUsername);
        if (!userNameMatches) {
            status.problems.add("User name doesn't match ( user name in license file: " + readUsername + " / current user name: " + localOSUserName + " )");
            logger.warn("License Server: Username (" + localOSUserName + ") does not match name in license file (" + readUsername + ")");
        }
        return userNameMatches;
    }

    public static String getHostname() throws HostNameRetriever.UnableToRetrieveHostnameException {
        return HostNameRetriever.getHostname();
    }

    @Deprecated
    public static String getHostID() throws HostNameRetriever.UnableToRetrieveHostnameException {
        String hostname = LicenseFileReader.getHostname();
        return Crypt.crypt(hostname, "ID");
    }

    public static String getHostID2() throws HostNameRetriever.UnableToRetrieveHostnameException {
        String hostname = LicenseFileReader.getHostname();
        return PasswordEncoder2.encodePassword(hostname);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkExpiryDate(String p_expiryDateLine, Date installDate, ValidityDefinition validityDefinition, LicenseFileReaderLicenseFileStatus status) {
        Date expiryDate;
        String expiryDateLine;
        String string = expiryDateLine = p_expiryDateLine == null ? "" : p_expiryDateLine;
        if (!expiryDateLine.startsWith("expires ")) {
            logger.warn("License Server: Invalid expiry date line in license file (does not start with \"expires\"): " + expiryDateLine);
            status.problems.add("Invalid file format (expiry date)");
            return false;
        }
        if ((expiryDateLine = expiryDateLine.substring(8)).trim().equals("never")) {
            validityDefinition.currentExpiryDate = -1L;
            return true;
        }
        if (expiryDateLine.trim().startsWith("after")) {
            long installTime;
            if (installDate == null) {
                status.problems.add("Relative expiry dates not allowed");
                return false;
            }
            String expiryDateLineTrimmed = expiryDateLine.trim();
            if (!expiryDateLineTrimmed.endsWith("days")) {
                logger.warn("License Server: Invalid expiry duration in license file (invalid unit): " + expiryDateLine);
                status.problems.add("Invalid file format (expiry date)");
                return false;
            }
            String daysString = expiryDateLineTrimmed.substring(5, expiryDateLineTrimmed.length() - 4).trim();
            int days = Integer.parseInt(daysString);
            validityDefinition.currentValidFromDate = installTime = installDate.getTime();
            expiryDate = new Date(installTime + (long)days * 86400000L);
        } else {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                expiryDate = dateFormat.parse(expiryDateLine);
            }
            catch (ParseException e) {
                logger.warn("License Server: Invalid expiry date in license file: " + expiryDateLine);
                status.problems.add("Invalid file format (expiry date)");
                return false;
            }
        }
        Date systemDate = new Date(System.currentTimeMillis() - 86400000L);
        if (systemDate.before(expiryDate)) {
            validityDefinition.currentExpiryDate = expiryDate.getTime();
            validityDefinition.currentExpiryDateText = DateFormat.getDateInstance(2, new Locale("en", "uk")).format(expiryDate);
            return true;
        }
        status.problems.add("Expired ( " + DateFormat.getDateInstance(2, new Locale("en", "uk")).format(expiryDate) + " )");
        return false;
    }

    private static boolean checkValidFromDate(String p_validFromDateLine, ValidityDefinition validityDefinition, LicenseFileReaderLicenseFileStatus status) {
        String validFromDateLine;
        block4: {
            String string = validFromDateLine = p_validFromDateLine == null ? "" : p_validFromDateLine;
            if (!validFromDateLine.startsWith("valid from ")) {
                logger.warn("License Server: Invalid valid from line in license file (does not start with \"valid from\"): " + validFromDateLine);
                status.problems.add("- Invalid file format (Valid from date)");
                return false;
            }
            validFromDateLine = validFromDateLine.substring(11);
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                Date validFromDate = dateFormat.parse(validFromDateLine);
                Date systemDate = new Date(System.currentTimeMillis());
                validityDefinition.currentValidFromDate = validFromDate.getTime();
                if (!systemDate.after(validFromDate)) break block4;
                return true;
            }
            catch (ParseException e) {
                logger.warn("License Server: Invalid valid from date in license file: " + validFromDateLine);
                status.problems.add("Invalid file format (Valid from date)");
                return false;
            }
        }
        status.problems.add("Not yet valid ( " + validFromDateLine.trim() + " )");
        return false;
    }

    private static String readLicenseFileSection(BufferedReader reader, ValidityDefinition validityDefinition, Map<String, UserLicense> allowedNumberOfUsers, MapMap<String, String, ModuleLicense> allowedModules, LicenseFileReaderLicenseFileStatus status, boolean isOld) throws IOException {
        while (reader.ready()) {
            String nextLine = reader.readLine();
            if (nextLine == null) continue;
            if (nextLine.startsWith(SERVER_TAG)) {
                return nextLine;
            }
            if (nextLine.startsWith("user licenses: ")) {
                LicenseFileReader.readUserLicenseLine(nextLine, validityDefinition, allowedNumberOfUsers, status, isOld);
                continue;
            }
            if (nextLine.startsWith("permitted module: ")) {
                LicenseFileReader.readModuleLicenseLine(nextLine, validityDefinition, allowedModules, status);
                continue;
            }
            if (nextLine.startsWith("company:") || nextLine.startsWith("user:") || nextLine.startsWith("remark:")) continue;
            System.out.println("License Server: Unexpected line in license file: " + nextLine);
        }
        return null;
    }

    private static boolean isValidOldApplicationID(String applicationID) {
        boolean is35;
        boolean is2 = applicationID.equals(PRODUCT_ID_COCKPIT_2_CS_FULL) || applicationID.startsWith("COCKPIT-2-");
        boolean is3 = applicationID.equals(PRODUCT_ID_COCKPIT_3_CS_FULL) || applicationID.startsWith("COCKPIT-3-");
        boolean bl = is35 = applicationID.equals(PRODUCT_ID_COCKPIT_35_CS_FULL) || applicationID.startsWith("COCKPIT-3.5-");
        return is2 || is3 || is35;
    }

    private static String skipLicenseFileSection(BufferedReader reader) throws IOException {
        while (reader.ready()) {
            String nextLine = reader.readLine();
            if (nextLine == null || !nextLine.startsWith(SERVER_TAG)) continue;
            return nextLine;
        }
        return null;
    }

    private static void readUserLicenseLine(String p_userLicenseLine, ValidityDefinition validityDefinition, Map<String, UserLicense> allowedNumberOfUsers, LicenseFileReaderLicenseFileStatus status, boolean isOld) {
        block7: {
            String userLicenseLine = p_userLicenseLine;
            userLicenseLine = userLicenseLine.substring(15);
            if ((userLicenseLine = userLicenseLine.trim()).indexOf(32) > 0) {
                String applicationName = userLicenseLine.substring(0, userLicenseLine.indexOf(32));
                if (isOld && !LicenseFileReader.isValidOldApplicationID(applicationName)) {
                    status.problems.add("The key that was used to sign the license file is revoked for " + applicationName + ". Contact ARCWAY AG to get a new license file.");
                } else {
                    String licenseCountString = null;
                    try {
                        licenseCountString = userLicenseLine.substring(userLicenseLine.indexOf(32) + 1);
                        licenseCountString = licenseCountString.trim();
                        int licenseCount = 0;
                        licenseCount = licenseCountString.equals("unlimited") ? -1 : Integer.parseInt(licenseCountString);
                        LicenseFileReaderUserLicenseStatus userStatus = new LicenseFileReaderUserLicenseStatus();
                        userStatus.applicationName = applicationName;
                        userStatus.userCount = licenseCount;
                        userStatus.expiryDate = validityDefinition.currentExpiryDate;
                        status.userLicenses.add(userStatus);
                        if (allowedNumberOfUsers.containsKey(applicationName)) {
                            UserLicense oldLicense = allowedNumberOfUsers.get(applicationName);
                            oldLicense.addLicenses(licenseCount, validityDefinition.currentValidFromDate, validityDefinition.currentExpiryDate);
                            break block7;
                        }
                        allowedNumberOfUsers.put(applicationName, new UserLicense(applicationName, licenseCount, validityDefinition.currentValidFromDate, validityDefinition.currentExpiryDate));
                    }
                    catch (NumberFormatException nfE) {
                        logger.warn("License Server: Invalid user license line (license count)" + licenseCountString);
                        status.problems.add("Invalid file format (User license line)");
                    }
                }
            } else {
                logger.warn("License Server: Invalid user license line (application name or license count missing)" + userLicenseLine);
                status.problems.add("Invalid file format (User license line)");
            }
        }
    }

    private static void readModuleLicenseLine(String p_moduleLicenseLine, ValidityDefinition validityDefinition, MapMap<String, String, ModuleLicense> allowedModules, LicenseFileReaderLicenseFileStatus status) {
        String moduleLicenseLine = p_moduleLicenseLine;
        moduleLicenseLine = moduleLicenseLine.substring(18);
        if ((moduleLicenseLine = moduleLicenseLine.trim()).indexOf(32) > 0) {
            String applicationName = moduleLicenseLine.substring(0, moduleLicenseLine.indexOf(32));
            String moduleName = moduleLicenseLine.substring(moduleLicenseLine.indexOf(32) + 1);
            ModuleLicense moduleLicense = allowedModules.get(applicationName, moduleName = moduleName.trim());
            if (moduleLicense == null) {
                allowedModules.put(applicationName, moduleName, new ModuleLicense(moduleName, validityDefinition.currentValidFromDate, validityDefinition.currentExpiryDate));
            } else {
                moduleLicense.addLicense(validityDefinition.currentValidFromDate, validityDefinition.currentExpiryDate);
            }
            LicenseFileReaderModuleLicenseStatus moduleStatus = new LicenseFileReaderModuleLicenseStatus();
            moduleStatus.applicationName = applicationName;
            moduleStatus.moduleName = moduleName;
            moduleStatus.expiryDate = validityDefinition.currentExpiryDate;
            status.allowedModules.add(moduleStatus);
        } else {
            System.out.println("License Server: Invalid module license line (application name or module name missing)" + moduleLicenseLine);
            status.problems.add("Invalid file format (module license line)");
        }
    }

    public static String getRevision() {
        String licenseFileReaderRevision = "$Revision: 1.48 $";
        licenseFileReaderRevision = licenseFileReaderRevision.substring(11, licenseFileReaderRevision.length() - 2);
        return licenseFileReaderRevision;
    }

    public static class LicenseFileReaderLicenseFileStatus {
        File licenseFile;
        String licenseFileID;
        public List<LicenseFileReaderUserLicenseStatus> userLicenses = new ArrayList<LicenseFileReaderUserLicenseStatus>();
        public List<LicenseFileReaderModuleLicenseStatus> allowedModules = new ArrayList<LicenseFileReaderModuleLicenseStatus>();
        public List<String> problems = new ArrayList<String>();
    }

    public static class LicenseFileReaderModuleLicenseStatus {
        public String applicationName = "";
        public String moduleName = "";
        public long expiryDate = 0L;
    }

    public static class LicenseFileReaderStatus {
        private final List<File> licenseFileDirectories = new ArrayList<File>();
        private final ListMap<File, LicenseFileReaderLicenseFileStatus> map_licenseFileDirectory_licenseFilesStatus = new ListMap();

        void addLicenseFileStatus(File directory, LicenseFileReaderLicenseFileStatus status) {
            if (!this.licenseFileDirectories.contains(directory)) {
                this.licenseFileDirectories.add(directory);
            }
            this.map_licenseFileDirectory_licenseFilesStatus.add(directory, status);
        }

        public String getStatusHTML() {
            String licenseStatus = "";
            if (!this.licenseFileDirectories.isEmpty()) {
                for (File directory : this.licenseFileDirectories) {
                    licenseStatus = String.valueOf(licenseStatus) + "<B>License file directory:</B>&nbsp;" + directory.getAbsolutePath() + "<BR><BR>";
                    licenseStatus = String.valueOf(licenseStatus) + "<TABLE border=\"1\" cellpadding=\"5\">";
                    licenseStatus = String.valueOf(licenseStatus) + "<TR><TH width=\"200\">License file name</TH><TH width=\"200\">License file ID</TH>";
                    licenseStatus = String.valueOf(licenseStatus) + "<TH width=\"200\">User licenses</TH><TH width=\"150\">Allowed optional modules</TH>";
                    licenseStatus = String.valueOf(licenseStatus) + "<TH width=\"300\">Problems</TH></TR>";
                    for (LicenseFileReaderLicenseFileStatus status : this.map_licenseFileDirectory_licenseFilesStatus.get((Object)directory)) {
                        licenseStatus = String.valueOf(licenseStatus) + "<TR>";
                        licenseStatus = String.valueOf(licenseStatus) + "<TD>" + status.licenseFile.getName() + "</TD>" + "<TD>" + status.licenseFileID + "</TD>" + "<TD>" + this.getUserLicenseStatusHTMLSnippet(status) + "</TD>" + "<TD>" + this.getModuleLicenseStatusHTMLSnippet(status) + "</TD>" + "<TD>" + this.getProblemsHTMLSnippet(status) + "</TD";
                        licenseStatus = String.valueOf(licenseStatus) + "</TR>";
                    }
                    licenseStatus = String.valueOf(licenseStatus) + "</TABLE><BR>";
                }
            } else {
                licenseStatus = "There are no license files deployed.";
            }
            return licenseStatus;
        }

        public LicenseFileReaderLicenseFileStatus getStatusForSpecificFile(File licenseFile) {
            File directory = licenseFile.getParentFile();
            for (LicenseFileReaderLicenseFileStatus status : this.map_licenseFileDirectory_licenseFilesStatus.get((Object)directory)) {
                if (!status.licenseFile.equals(licenseFile)) continue;
                return status;
            }
            return null;
        }

        private String getUserLicenseStatusHTMLSnippet(LicenseFileReaderLicenseFileStatus status) {
            String snippet = "";
            if (!status.userLicenses.isEmpty()) {
                for (LicenseFileReaderUserLicenseStatus userStatus : status.userLicenses) {
                    snippet = String.valueOf(snippet) + "- " + userStatus.applicationName + ": ";
                    snippet = String.valueOf(snippet) + (userStatus.userCount != -1 ? Integer.toString(userStatus.userCount) : "unlimited");
                    snippet = String.valueOf(snippet) + " (expires: " + (userStatus.expiryDate != -1L ? new Date(userStatus.expiryDate).toString() : "never") + ")";
                    snippet = String.valueOf(snippet) + "<BR>";
                }
            } else {
                snippet = "none";
            }
            return snippet;
        }

        private String getModuleLicenseStatusHTMLSnippet(LicenseFileReaderLicenseFileStatus status) {
            String snippet = "";
            if (!status.allowedModules.isEmpty()) {
                for (LicenseFileReaderModuleLicenseStatus moduleStatus : status.allowedModules) {
                    snippet = String.valueOf(snippet) + "- " + moduleStatus.applicationName + ": " + moduleStatus.moduleName;
                    snippet = String.valueOf(snippet) + " (expires: " + (moduleStatus.expiryDate != -1L ? new Date(moduleStatus.expiryDate).toString() : "never") + ")";
                    snippet = String.valueOf(snippet) + "<BR>";
                }
            } else {
                snippet = "none";
            }
            return snippet;
        }

        private String getProblemsHTMLSnippet(LicenseFileReaderLicenseFileStatus status) {
            String problemSnippet = "";
            if (!status.problems.isEmpty()) {
                for (String problem : status.problems) {
                    problemSnippet = String.valueOf(problemSnippet) + "- " + problem + "<BR>";
                }
            } else {
                problemSnippet = "&nbsp;";
            }
            return problemSnippet;
        }
    }

    public static class LicenseFileReaderUserLicenseStatus {
        public String applicationName = "";
        public int userCount = 0;
        public long expiryDate = 0L;
    }

    private static class ValidityDefinition {
        long currentValidFromDate;
        long currentExpiryDate;
        String currentExpiryDateText;

        private ValidityDefinition() {
        }
    }
}

