/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.listener;

import com.arcway.lib.java.Assert;
import com.arcway.lib.listener.IDisposeListener;
import com.arcway.lib.listener.IListenerCaller;
import com.arcway.lib.listener.ListenerKey;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ListenerManager<L extends IDisposeListener>
implements IDisposeListener {
    private static final ILogger logger = Logger.getLogger(ListenerManager.class);
    private final Map<ListenerKey, ListenerEntry<L>> listenerMap = new HashMap<ListenerKey, ListenerEntry<L>>();
    private boolean isDiposing = false;
    private boolean isDiposed = false;

    public void addListener(ListenerKey key, L listener) {
        Assert.checkArgumentBeeingNotNull(listener);
        Assert.checkState(!this.isDiposed);
        Assert.checkState(!this.isDiposing);
        Assert.checkArgumentBeeingNotNull(key);
        Assert.checkArgument(this.getListener(key) == null);
        ListenerEntry newListenerEntry = new ListenerEntry(key, (IDisposeListener)listener, new Exception(), null);
        this.listenerMap.put(key, newListenerEntry);
    }

    public boolean hasNoListeners() {
        return this.listenerMap.isEmpty();
    }

    public L getListener(ListenerKey key) {
        Assert.checkState(!this.isDiposed);
        ListenerEntry<L> listenerEntry = this.listenerMap.get(key);
        IDisposeListener listener = listenerEntry != null ? ((ListenerEntry)listenerEntry).listener : null;
        return (L)listener;
    }

    public L removeListener(ListenerKey key) {
        Assert.checkState(!this.isDiposed);
        ListenerEntry<L> removedListenerEntry = this.listenerMap.remove(key);
        Assert.checkArgumentBeeingNotNull(removedListenerEntry);
        return (L)((ListenerEntry)removedListenerEntry).listener;
    }

    public void callListeners(IListenerCaller<L> listenerCaller) {
        Assert.checkState(!this.isDiposed);
        Assert.checkState(!this.isDiposing);
        ArrayList<ListenerEntry<L>> currentListenerEntries = new ArrayList<ListenerEntry<L>>(this.listenerMap.values());
        for (ListenerEntry listenerEntry : currentListenerEntries) {
            try {
                if (!this.listenerMap.containsKey(listenerEntry.key)) continue;
                listenerCaller.callListener(listenerEntry.listener);
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
    }

    @Override
    public void dispose() {
        Assert.checkState(!this.isDiposed);
        Assert.checkState(!this.isDiposing);
        this.isDiposing = true;
        int numberOfListenersBeforeCurrentPass = this.listenerMap.size();
        int numberOfListenersAfterCurrentPass = -1;
        while (numberOfListenersAfterCurrentPass < numberOfListenersBeforeCurrentPass) {
            numberOfListenersBeforeCurrentPass = this.listenerMap.size();
            ArrayList<Map.Entry<ListenerKey, ListenerEntry<L>>> currentListenerMapEntries = new ArrayList<Map.Entry<ListenerKey, ListenerEntry<L>>>(this.listenerMap.entrySet());
            for (Map.Entry entry : currentListenerMapEntries) {
                ListenerKey key = (ListenerKey)entry.getKey();
                ListenerEntry listenerEntry = (ListenerEntry)entry.getValue();
                if (!this.listenerMap.containsKey(key)) continue;
                try {
                    listenerEntry.listener.dispose();
                    if (!this.listenerMap.containsKey(key)) continue;
                    this.removeListener(key);
                    logger.error("Listener was requested to dispose, but it has not unregistered itself.");
                    logger.error("Registration trace: ", listenerEntry.registrationTrace);
                }
                catch (Throwable e) {
                    if (this.listenerMap.containsKey(key)) {
                        logger.error("Listener was not unregistered due to exception", e);
                        logger.error("Registration trace: ", listenerEntry.registrationTrace);
                        this.removeListener(key);
                        continue;
                    }
                    logger.error("Exception while listener was unregistered", e);
                }
            }
            numberOfListenersAfterCurrentPass = this.listenerMap.size();
        }
        if (numberOfListenersAfterCurrentPass > 0) {
            Iterator<Map.Entry<ListenerKey, ListenerEntry<L>>> i = this.listenerMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<ListenerKey, ListenerEntry<L>> entry = i.next();
                i.remove();
                logger.error("A listener remained unregistered. Registration trace: ", ((ListenerEntry)entry.getValue()).registrationTrace);
            }
            throw new IllegalStateException("After disposal, some listeners remained unregistered.");
        }
        this.isDiposed = true;
        this.isDiposing = false;
    }

    private static class ListenerEntry<L extends IDisposeListener> {
        private final Object key;
        private final L listener;
        private final Exception registrationTrace;

        private ListenerEntry(Object key, L listener, Exception registrationTrace) {
            this.key = key;
            this.listener = listener;
            this.registrationTrace = registrationTrace;
        }

        /* synthetic */ ListenerEntry(Object object, IDisposeListener iDisposeListener, Exception exception, ListenerEntry listenerEntry) {
            this(object, iDisposeListener, exception);
        }
    }
}

