/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.maps;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISortedSetIteratorRW_;
import com.arcway.lib.java.collections.ISortedSet_;
import com.arcway.lib.java.collections.JSortedSet_;
import com.arcway.lib.java.collections.SortedSet_;
import com.arcway.lib.java.maps.AbstractMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.ISortedMapRW_;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SortedMap_<K, V>
extends AbstractMap_<K, V>
implements ISortedMapRW_<K, V> {
    public SortedMap_(IComparator_<? super K> comparator) {
        super(new TreeMap(new MapKeyJComparator(comparator)), new SortedSet_.JHasher<K>(comparator));
    }

    public SortedMap_(ICollection_<? extends IEntry_<? extends K, ? extends V>> initialContent, IComparator_<? super K> comparator) {
        this(comparator);
        assert (Assert.checkArgumentBeeingNotNull(initialContent));
        this.addAll(initialContent);
    }

    public SortedMap_(Map<? extends K, ? extends V> initialContent, IComparator_<? super K> comparator) {
        this(comparator);
        assert (Assert.checkArgumentBeeingNotNull(initialContent));
        for (Map.Entry<K, V> entry : initialContent.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            Assert.checkArgument(!this.containsKey(key), "duplicate key in java map");
            this.put(key, value);
        }
    }

    @Override
    public int getIndexOfKey(K key) {
        int indexFound = -1;
        int index = 0;
        for (IEntry_ entry : this) {
            if (entry != null && this.getKeyHasher().isEqual(entry.getKey(), key)) {
                indexFound = index;
            }
            ++index;
        }
        return indexFound;
    }

    @Override
    public V getValue(int index) {
        Object foundEntry = this.get(index);
        return foundEntry != null ? (V)foundEntry.getValue() : null;
    }

    @Override
    public int getIndexOf(IEntry_<? extends K, ? extends V> object) {
        assert (Assert.checkArgumentBeeingNotNull(object));
        return this.getIndexOfKey(object.getKey());
    }

    @Override
    public List<IEntry_<? extends K, ? extends V>> asJavaList() {
        return new JSortedSet_<IEntry_<? extends K, ? extends V>>(this);
    }

    @Override
    public IEntry_<? extends K, ? extends V> get(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        Iterator i = this.iterator();
        int count = index;
        while (count > 0) {
            assert (Assert.checkArgument(i.hasNext()));
            i.next();
            --count;
        }
        assert (Assert.checkArgument(i.hasNext()));
        return (IEntry_)i.next();
    }

    @Override
    public ISortedSet_<K> keySet() {
        return (ISortedSet_)super.keySet();
    }

    @Override
    public IList_<V> values() {
        return (IList_)super.values();
    }

    @Override
    public ISortedSetIteratorRW_<IEntry_<? extends K, ? extends V>> iterator() {
        return new It_();
    }

    @Override
    public void remove(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        Iterator i = this.iterator();
        int count = index;
        while (count >= 0) {
            assert (Assert.checkArgument(i.hasNext()));
            i.next();
            --count;
        }
        i.remove();
    }

    private final class It_
    implements ISortedSetIteratorRW_<IEntry_<? extends K, ? extends V>> {
        private final Iterator<? extends Map.Entry<? extends Object, IEntry_<? extends K, ? extends V>>> javaIterator;

        protected It_() {
            this.javaIterator = SortedMap_.this.getJavaMap().entrySet().iterator();
        }

        @Override
        public int index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.javaIterator.hasNext();
        }

        @Override
        public IEntry_<? extends K, ? extends V> next() {
            return this.javaIterator.next().getValue();
        }

        @Override
        public boolean hasPrev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IEntry_<? extends K, ? extends V> prev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            this.javaIterator.remove();
        }
    }

    private static final class MapKeyJComparator<X, Y>
    implements Comparator<AbstractMap_.MapKey> {
        private final IComparator_<? super X> iComparator;

        public MapKeyJComparator(IComparator_<? super X> comparator) {
            Assert.checkArgumentBeeingNotNull(comparator);
            this.iComparator = comparator;
        }

        @Override
        public int compare(AbstractMap_.MapKey o1, AbstractMap_.MapKey o2) {
            return this.iComparator.sgn(o1.wrappedObject, o2.wrappedObject);
        }
    }
}

