/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.locale.resourcebundles;

import com.arcway.lib.java.locale.LocaleHelper;
import com.arcway.lib.java.locale.resourcebundles.GeneralResourceBundleLoader;
import com.arcway.lib.java.locale.resourcebundles.IGeneralResourceBundleLoader;
import com.arcway.lib.java.locale.resourcebundles.IResourceBundleLoaderPolicy;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ArcwayStandardResourceBundleLoader {
    private static final Locale ENGLISH_LOCALE = new Locale("en");
    private static final IResourceBundleLoaderPolicy arcwayStandardResourceBundleLoaderPolicy = new IResourceBundleLoaderPolicy(){

        @Override
        public ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader, IGeneralResourceBundleLoader resourceBundleLoader) throws MissingResourceException {
            if (!locale.equals(Locale.getDefault()) && LocaleHelper.getDistance(locale, ENGLISH_LOCALE) < 3) {
                return resourceBundleLoader.getBundle(bundleName, locale, classLoader, false, ENGLISH_LOCALE);
            }
            return resourceBundleLoader.getBundle(bundleName, locale, classLoader, true, ENGLISH_LOCALE);
        }
    };

    public static ResourceBundle getBundle(String bundleName, Locale locale, Class<?> referer) throws MissingResourceException {
        return ArcwayStandardResourceBundleLoader.getBundle(bundleName, locale, referer.getClassLoader());
    }

    public static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader classLoader) throws MissingResourceException {
        return GeneralResourceBundleLoader.getBundle(bundleName, locale, classLoader, arcwayStandardResourceBundleLoaderPolicy);
    }
}

