/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.java.collections;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.AbstractSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IComparator_;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.java.collections.ISortedSetIteratorRW_;
import com.arcway.lib.java.collections.ISortedSetRW_;
import com.arcway.lib.java.collections.JSortedSet_;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SortedSet_<T>
extends AbstractSet_<T>
implements ISortedSetRW_<T> {
    public SortedSet_(IComparator_<? super T> comparator) {
        super(new TreeMap(new MapKeyJComparator<T>(comparator)), new JHasher<T>(comparator));
    }

    public SortedSet_(ICollection_<? extends T> initialContent, IComparator_<? super T> comparator) {
        this(comparator);
        assert (Assert.checkArgumentBeeingNotNull(initialContent));
        this.addAll(initialContent);
    }

    public SortedSet_(Collection<? extends T> initialContent, IComparator_<? super T> comparator) {
        this(comparator);
        assert (Assert.checkArgumentBeeingNotNull(initialContent));
        this.addAll(initialContent);
    }

    public SortedSet_(T initialContent, IComparator_<? super T> comparator) {
        this(comparator);
        assert (Assert.checkArgumentBeeingNotNull(initialContent));
        this.add(initialContent);
    }

    @Override
    public ISortedSetIteratorRW_<T> iterator() {
        return new It_();
    }

    @Override
    public int getIndexOf(T object) {
        int indexFound = -1;
        int index = 0;
        for (Object element : this) {
            if (this.getKeyHasher().isEqual(element, object)) {
                indexFound = index;
            }
            ++index;
        }
        return indexFound;
    }

    @Override
    public List<T> asJavaList() {
        return new JSortedSet_(this);
    }

    @Override
    public T get(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        Iterator i = this.iterator();
        int count = index;
        while (count > 0) {
            assert (Assert.checkArgument(i.hasNext()));
            i.next();
            --count;
        }
        assert (Assert.checkArgument(i.hasNext()));
        return (T)i.next();
    }

    @Override
    public void remove(int index) {
        assert (Assert.checkArgument(index >= 0));
        assert (Assert.checkArgument(index < this.size()));
        Iterator i = this.iterator();
        int count = index;
        while (count >= 0) {
            assert (Assert.checkArgument(i.hasNext()));
            i.next();
            --count;
        }
        i.remove();
    }

    private final class It_
    implements ISortedSetIteratorRW_<T> {
        private final Iterator<? extends Map.Entry<? extends Object, T>> javaIterator;

        protected It_() {
            this.javaIterator = SortedSet_.this.getJavaMap().entrySet().iterator();
        }

        @Override
        public int index() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.javaIterator.hasNext();
        }

        @Override
        public T next() {
            return this.javaIterator.next().getValue();
        }

        @Override
        public boolean hasPrev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T prev() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            this.javaIterator.remove();
        }
    }

    public static final class JHasher<X>
    implements IHasher_<X> {
        private final IComparator_<? super X> iComparator;

        public JHasher(IComparator_<? super X> comparator) {
            Assert.checkArgumentBeeingNotNull(comparator);
            this.iComparator = comparator;
        }

        @Override
        public int getHashCode(X object) {
            return this.iComparator.getHashCode(object);
        }

        @Override
        public boolean isEqual(X object1, X object2) {
            return this.iComparator.sgn(object1, object2) == 0;
        }
    }

    private static final class MapKeyJComparator<X>
    implements Comparator<AbstractSet_.MapKey> {
        private final IComparator_<? super X> iComparator;

        public MapKeyJComparator(IComparator_<? super X> comparator) {
            Assert.checkArgumentBeeingNotNull(comparator);
            this.iComparator = comparator;
        }

        @Override
        public int compare(AbstractSet_.MapKey o1, AbstractSet_.MapKey o2) {
            return this.iComparator.sgn(o1.wrappedObject, o2.wrappedObject);
        }
    }
}

