/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.extensioning;

import com.arcway.lib.extensioning.IPlugin;
import com.arcway.lib.extensioning.ObjectExtensionPoint;
import com.arcway.lib.java.Assert;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.Iterator;

public abstract class SingletonObjectExtensionPoint
extends ObjectExtensionPoint {
    private static final ILogger logger = Logger.getLogger(SingletonObjectExtensionPoint.class);

    protected SingletonObjectExtensionPoint(IPlugin plugin, String extensionPointID, String configElementName, String attributeName, Class instanceType) {
        super(plugin, extensionPointID, configElementName, attributeName, instanceType);
    }

    @Override
    protected void storeCreatedObjects(ICollection_<Object> instances) {
        Iterator i = instances.iterator();
        if (i.hasNext()) {
            Object usedInstance = i.next();
            this.storeCreatedObject(usedInstance);
            if (i.hasNext()) {
                logger.warn("More than one registered extensions found for extension point " + this + ")");
                logger.warn("  - used extension: " + usedInstance);
                while (i.hasNext()) {
                    Object unusedInstance = i.next();
                    logger.warn("  - unused extension: " + unusedInstance);
                }
            }
        } else {
            Assert.illegalArgument("Could not find the extension for the extension point " + this + "!");
        }
    }

    protected abstract void storeCreatedObject(Object var1);
}

