/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.lib.codec.xml;

import com.arcway.lib.java.Assert;
import com.arcway.lib.java.To;
import com.arcway.lib.java.collections.IHasher_;
import com.arcway.lib.stringtools.StringCanonicalizer;

public class XMLAttributeName {
    public static final IHasher_<XMLAttributeName> IS_EQUAL_XML_ATTRIBUTE_NAME_HASHER = new IHasher_<XMLAttributeName>(){

        @Override
        public boolean isEqual(XMLAttributeName xMLAttributeName1, XMLAttributeName xMLAttributeName2) {
            return xMLAttributeName1.isEqualXMLAttributeName(xMLAttributeName2);
        }

        @Override
        public int getHashCode(XMLAttributeName xMLAttributeName) {
            return xMLAttributeName.hashCodeForIsEqualXMLAttributeName();
        }
    };
    private final String attributeName;

    public XMLAttributeName(String attributeName) {
        Assert.checkArgumentBeeingNotNull(attributeName);
        Assert.checkStringToBeNotEmpty(attributeName);
        this.attributeName = StringCanonicalizer.getSystemWideCanonicalString(attributeName);
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean isEqualXMLAttributeName(XMLAttributeName attributeNameToCompare) {
        Assert.checkArgumentBeeingNotNull(attributeNameToCompare);
        return this.attributeName.equals(attributeNameToCompare.attributeName);
    }

    public int hashCodeForIsEqualXMLAttributeName() {
        return this.attributeName.hashCode();
    }

    public String toString() {
        return String.valueOf(To.string(this)) + " (\"" + this.getAttributeName() + "\")";
    }
}

